/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalDryingBasin;

public class RecipeSerializerMechanicalDryingBasin
implements RecipeSerializer<RecipeMechanicalDryingBasin> {
    public RecipeMechanicalDryingBasin fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)false);
        FluidStack inputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)json, (String)"fluid", (boolean)false);
        Either outputItemStack = RecipeSerializerHelpers.getJsonItemStackOrTag((JsonObject)result, (boolean)false, GeneralConfig.recipeTagOutputModPriorities);
        FluidStack outputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)result, (String)"fluid", (boolean)false);
        int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
        if (inputIngredient.m_43947_() && inputFluid.isEmpty()) {
            throw new JsonSyntaxException("An input item or fluid is required");
        }
        if (outputItemStack.left().isPresent() && outputItemStack.left().isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        if (!inputFluid.isEmpty() && !outputFluid.isEmpty()) {
            throw new JsonSyntaxException("Can't have both an input and output fluid");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        return new RecipeMechanicalDryingBasin(recipeId, inputIngredient, inputFluid, (Either<ItemStack, ItemStackFromIngredient>)outputItemStack, outputFluid, duration);
    }

    @Nullable
    public RecipeMechanicalDryingBasin fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient inputIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        FluidStack inputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        Either outputItem = RecipeSerializerHelpers.readItemStackOrItemStackIngredient((FriendlyByteBuf)buffer);
        FluidStack outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        int duration = buffer.m_130242_();
        return new RecipeMechanicalDryingBasin(recipeId, inputIngredient, inputFluid, (Either<ItemStack, ItemStackFromIngredient>)outputItem, outputFluid, duration);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeMechanicalDryingBasin recipe) {
        recipe.getInputIngredient().m_43923_(buffer);
        recipe.getInputFluid().writeToPacket(buffer);
        RecipeSerializerHelpers.writeItemStackOrItemStackIngredient((FriendlyByteBuf)buffer, recipe.getOutputItem());
        recipe.getOutputFluid().writeToPacket(buffer);
        buffer.m_130130_(recipe.getDuration());
    }
}

