/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;

public class RecipeDryingBasin
implements Recipe<IInventoryFluid> {
    private final ResourceLocation id;
    private final Ingredient inputIngredient;
    private final FluidStack inputFluid;
    private final Either<ItemStack, ItemStackFromIngredient> outputItem;
    private final FluidStack outputFluid;
    private final int duration;

    public RecipeDryingBasin(ResourceLocation id, Ingredient inputIngredient, FluidStack inputFluid, Either<ItemStack, ItemStackFromIngredient> outputIngredient, FluidStack outputFluid, int duration) {
        this.id = id;
        this.inputIngredient = inputIngredient;
        this.inputFluid = inputFluid;
        this.outputItem = outputIngredient;
        this.outputFluid = outputFluid;
        this.duration = duration;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public Either<ItemStack, ItemStackFromIngredient> getOutputItem() {
        return this.outputItem;
    }

    public ItemStack getOutputItemFirst() {
        return (ItemStack)this.getOutputItem().map(l -> l, ItemStackFromIngredient::getFirstItemStack);
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean matches(IInventoryFluid inv, Level worldIn) {
        return this.inputIngredient.test(inv.m_8020_(0)) && this.inputFluid.getFluid() == inv.getFluidHandler().getFluidInTank(0).getFluid() && this.inputFluid.getAmount() <= inv.getFluidHandler().getFluidInTank(0).getAmount();
    }

    public ItemStack assemble(IInventoryFluid inv, RegistryAccess registryAccess) {
        return this.getOutputItemFirst().m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getOutputItemFirst().m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_DRYING_BASIN;
    }

    public RecipeType<?> m_6671_() {
        return RegistryEntries.RECIPETYPE_DRYING_BASIN;
    }
}

