/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics.http;

import com.google.gson.JsonParser;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDataClient;
import org.cyclops.integrateddynamics.vendors.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.cyclops.integrateddynamics.vendors.io.netty.handler.codec.http.HttpContent;
import org.cyclops.integrateddynamics.vendors.io.netty.handler.codec.http.HttpHeaderNames;
import org.cyclops.integrateddynamics.vendors.io.netty.handler.codec.http.HttpMethod;
import org.cyclops.integrateddynamics.vendors.io.netty.handler.codec.http.HttpRequest;
import org.cyclops.integrateddynamics.vendors.io.netty.handler.codec.http.HttpResponseStatus;
import org.cyclops.integrateddynamics.vendors.io.netty.handler.codec.http.HttpUtil;
import org.cyclops.integrateddynamics.vendors.io.netty.handler.codec.http.HttpVersion;

public class DiagnosticsWebServerHandler
extends SimpleChannelInboundHandler<Object> {
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext context, Object message) throws Exception {
        if (message instanceof HttpRequest) {
            String responseString;
            HttpResponseStatus responseStatus;
            HttpRequest request = (HttpRequest)message;
            if (HttpUtil.is100ContinueExpected(request)) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
                context.write((Object)response);
            }
            if (!this.writeResponse(request, context, responseString, switch (request.uri()) {
                case "/" -> {
                    responseStatus = HttpResponseStatus.OK;
                    InputStream is = IntegratedDynamics.class.getResourceAsStream("/data/integrateddynamics/web/diagnostics.html");
                    responseString = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    yield "text/html; charset=UTF-8";
                }
                case "/data.json" -> {
                    responseStatus = HttpResponseStatus.OK;
                    responseString = NetworkDataClient.getAsJsonString();
                    yield "application/json; charset=UTF-8";
                }
                case "/highlightEnable" -> {
                    if (request.method().equals(HttpMethod.POST) && request instanceof HttpContent) {
                        HttpContent httpRequest = (HttpContent)((Object)request);
                        NetworkDataClient.highlightEnable(JsonParser.parseString((String)httpRequest.content().toString(CharsetUtil.UTF_8)).getAsJsonObject());
                    }
                    responseStatus = HttpResponseStatus.OK;
                    responseString = "Ok";
                    yield "text/plain; charset=UTF-8";
                }
                case "/highlightDisable" -> {
                    if (request.method().equals(HttpMethod.POST) && request instanceof HttpContent) {
                        HttpContent httpRequest = (HttpContent)((Object)request);
                        NetworkDataClient.highlightDisable(JsonParser.parseString((String)httpRequest.content().toString(CharsetUtil.UTF_8)).getAsJsonObject());
                    }
                    responseStatus = HttpResponseStatus.OK;
                    responseString = "Ok";
                    yield "text/plain; charset=UTF-8";
                }
                case "/teleport" -> {
                    if (request.method().equals(HttpMethod.POST) && request instanceof HttpContent) {
                        HttpContent httpRequest = (HttpContent)((Object)request);
                        NetworkDataClient.teleport(JsonParser.parseString((String)httpRequest.content().toString(CharsetUtil.UTF_8)).getAsJsonObject());
                    }
                    responseStatus = HttpResponseStatus.OK;
                    responseString = "Ok";
                    yield "text/plain; charset=UTF-8";
                }
                default -> {
                    responseStatus = HttpResponseStatus.NOT_FOUND;
                    responseString = "Not found";
                    yield "text/plain; charset=UTF-8";
                }
            }, responseStatus)) {
                context.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    private boolean writeResponse(HttpRequest request, ChannelHandlerContext context, String responseString, String contentType, HttpResponseStatus responseStatus) {
        boolean keepAlive = HttpUtil.isKeepAlive(request);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.copiedBuffer((CharSequence)responseString, (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
        }
        context.write((Object)response);
        return keepAlive;
    }
}

