/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class EnergyHelpers {
    private static final List<IEnergyStorageProxy> ENERGY_STORAGE_PROXIES = Lists.newArrayList();

    public static void addEnergyStorageProxy(IEnergyStorageProxy energyStorageProxy) {
        ENERGY_STORAGE_PROXIES.add(energyStorageProxy);
    }

    public static LazyOptional<IEnergyStorage> getEnergyStorage(PartPos pos) {
        return EnergyHelpers.getEnergyStorage(pos.getPos(), pos.getSide());
    }

    public static LazyOptional<IEnergyStorage> getEnergyStorage(DimPos pos, Direction facing) {
        Level world = pos.getLevel(true);
        return world != null ? EnergyHelpers.getEnergyStorage((BlockGetter)world, pos.getBlockPos(), facing) : LazyOptional.empty();
    }

    public static LazyOptional<IEnergyStorage> getEnergyStorage(BlockGetter world, BlockPos pos, Direction facing) {
        IEnergyStorage energyStorage = (IEnergyStorage)BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)facing, (Capability)ForgeCapabilities.ENERGY).orElseGet(() -> {
            for (IEnergyStorageProxy energyStorageProxy : ENERGY_STORAGE_PROXIES) {
                LazyOptional<IEnergyStorage> optionalEnergyStorage = energyStorageProxy.getEnergyStorageProxy(world, pos, facing);
                if (!optionalEnergyStorage.isPresent()) continue;
                return (IEnergyStorage)optionalEnergyStorage.orElse(null);
            }
            return null;
        });
        return energyStorage == null ? LazyOptional.empty() : LazyOptional.of(() -> energyStorage);
    }

    public static int fillNeigbours(Level world, BlockPos pos, int energy, boolean simulate) {
        int toFill = energy;
        for (Direction side : Direction.values()) {
            IEnergyStorage energyStorage = (IEnergyStorage)EnergyHelpers.getEnergyStorage((BlockGetter)world, pos.m_121945_(side), side.m_122424_()).orElse(null);
            if (energyStorage == null || (toFill -= energyStorage.receiveEnergy(toFill, simulate)) > 0) continue;
            return energy;
        }
        return energy - toFill;
    }

    public static interface IEnergyStorageProxy {
        public LazyOptional<IEnergyStorage> getEnergyStorageProxy(BlockGetter var1, BlockPos var2, Direction var3);
    }
}

