/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.PositionedOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class PositionedOperatorNetworkVariableById
extends PositionedOperator {
    public PositionedOperatorNetworkVariableById(DimPos pos, Direction side) {
        super("variablebyid", "variablebyid", "variablebyid", new IValueType[]{ValueTypes.INTEGER}, ValueTypes.CATEGORY_ANY, new Function(), IConfigRenderPattern.PREFIX_1, pos, side);
        ((Function)this.getFunction()).setOperator(this);
    }

    public PositionedOperatorNetworkVariableById() {
        this(null, null);
        ((Function)this.getFunction()).setOperator(this);
    }

    @Override
    protected String getUnlocalizedType() {
        return "virtual";
    }

    public static class Function
    implements OperatorBase.IFunction {
        private PositionedOperatorNetworkVariableById operator;

        public void setOperator(PositionedOperatorNetworkVariableById operator) {
            this.operator = operator;
        }

        public PositionedOperatorNetworkVariableById getOperator() {
            return this.operator;
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            INetwork network = (INetwork)NetworkHelpers.getNetwork(PartPos.of(this.getOperator().getPos(), this.getOperator().getSide())).orElse(null);
            IPartNetwork partNetwork = (IPartNetwork)NetworkHelpers.getPartNetwork(network).orElse(null);
            if (network != null && partNetwork != null) {
                int variableId = variables.getValue(0, ValueTypes.INTEGER).getRawValue();
                IVariableFacade variableFacade = partNetwork.getVariableFacade(variableId);
                if (variableFacade != null) {
                    return variableFacade.getVariable(network, partNetwork).getValue();
                }
                EvaluationException exception = new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{variableId}));
                exception.setRetryEvaluation(true);
                throw exception;
            }
            EvaluationException exception = new EvaluationException(Component.m_237115_((String)"general.integrateddynamics.error.no_network"));
            exception.setRetryEvaluation(true);
            throw exception;
        }
    }
}

