/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.jetbrains.annotations.Nullable;

public class CurriedOperator
implements IOperator {
    private final IOperator baseOperator;
    private final IVariable[] appliedVariables;

    public CurriedOperator(IOperator baseOperator, IVariable ... appliedVariables) {
        this.baseOperator = baseOperator;
        this.appliedVariables = appliedVariables;
    }

    protected String getAppliedSymbol() {
        Object symbol = "";
        for (IVariable appliedVariable : this.appliedVariables) {
            symbol = (String)symbol + appliedVariable.getType().getTypeName() + ";";
        }
        return symbol;
    }

    @Override
    public String getSymbol() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseOperator.getSymbol());
        sb.append(" [");
        sb.append(this.getAppliedSymbol());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation("curried_operator");
    }

    @Override
    public String getInteractName() {
        return "curried_operator";
    }

    @Override
    @Nullable
    public String getGlobalInteractNamePrefix() {
        return null;
    }

    @Override
    public boolean shouldAlsoPrefixLocalScope() {
        return false;
    }

    @Override
    public String getTranslationKey() {
        return this.baseOperator.getTranslationKey();
    }

    @Override
    public String getUnlocalizedCategoryName() {
        return this.baseOperator.getUnlocalizedCategoryName();
    }

    @Override
    public MutableComponent getLocalizedNameFull() {
        return Component.m_237110_((String)"operator.integrateddynamics.applied.operator_name", (Object[])new Object[]{this.baseOperator.getLocalizedNameFull(), this.getAppliedSymbol()});
    }

    @Override
    public void loadTooltip(List<Component> lines, boolean appendOptionalInfo) {
        this.baseOperator.loadTooltip(lines, appendOptionalInfo);
        lines.add((Component)Component.m_237110_((String)"operator.integrateddynamics.applied.type", (Object[])new Object[]{this.getAppliedSymbol()}));
    }

    @Override
    public IValueType[] getInputTypes() {
        IValueType[] baseInputTypes = this.baseOperator.getInputTypes();
        return Arrays.copyOfRange(baseInputTypes, this.appliedVariables.length, baseInputTypes.length);
    }

    @Override
    public IValueType getOutputType() {
        return this.baseOperator.getOutputType();
    }

    protected IVariable[] deriveFullInputVariables(IVariable[] partialInput) {
        IVariable[] fullInput = new IVariable[Math.min(this.baseOperator.getRequiredInputLength(), partialInput.length + this.appliedVariables.length)];
        for (int i = 0; i < this.appliedVariables.length; ++i) {
            fullInput[i] = this.appliedVariables[i];
        }
        System.arraycopy(partialInput, 0, fullInput, this.appliedVariables.length, fullInput.length - this.appliedVariables.length);
        return fullInput;
    }

    protected IValueType[] deriveFullInputTypes(IValueType[] partialInput) {
        IValueType[] fullInput = new IValueType[Math.min(this.baseOperator.getRequiredInputLength(), partialInput.length + this.appliedVariables.length)];
        for (int i = 0; i < this.appliedVariables.length; ++i) {
            fullInput[i] = this.appliedVariables[i].getType();
        }
        System.arraycopy(partialInput, 0, fullInput, this.appliedVariables.length, fullInput.length - this.appliedVariables.length);
        return fullInput;
    }

    @Override
    public IValueType getConditionalOutputType(IVariable[] input) {
        return this.baseOperator.getConditionalOutputType(this.deriveFullInputVariables(input));
    }

    @Override
    public IValue evaluate(IVariable[] input) throws EvaluationException {
        return this.baseOperator.evaluate(this.deriveFullInputVariables(input));
    }

    @Override
    public int getRequiredInputLength() {
        return this.baseOperator.getRequiredInputLength() - this.appliedVariables.length;
    }

    @Override
    public MutableComponent validateTypes(IValueType[] input) {
        return this.baseOperator.validateTypes(this.deriveFullInputTypes(input));
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE;
    }

    @Override
    public IOperator materialize() throws EvaluationException {
        IVariable[] variables = new IVariable[this.appliedVariables.length];
        for (int i = 0; i < this.appliedVariables.length; ++i) {
            IVariable appliedVariable = this.appliedVariables[i];
            variables[i] = new Variable(appliedVariable.getType(), appliedVariable.getType().materialize(appliedVariable.getValue()));
        }
        return new CurriedOperator(this.baseOperator, variables);
    }

    public IOperator getBaseOperator() {
        return this.baseOperator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurriedOperator)) {
            return false;
        }
        CurriedOperator that = (CurriedOperator)o;
        return Objects.equals(this.baseOperator, that.baseOperator) && Arrays.equals(this.appliedVariables, that.appliedVariables);
    }

    public int hashCode() {
        int result = Objects.hash(this.baseOperator);
        result = 31 * result + Arrays.hashCode(this.appliedVariables);
        return result;
    }

    public static class Serializer
    implements IOperatorSerializer<CurriedOperator> {
        @Override
        public boolean canHandle(IOperator operator) {
            return operator instanceof CurriedOperator;
        }

        @Override
        public ResourceLocation getUniqueName() {
            return new ResourceLocation("integrateddynamics", "curry");
        }

        @Override
        public Tag serialize(CurriedOperator operator) {
            ListTag list = new ListTag();
            for (int i = 0; i < operator.appliedVariables.length; ++i) {
                Object value;
                IVariable appliedVariable = operator.appliedVariables[i];
                try {
                    value = appliedVariable.getValue();
                }
                catch (EvaluationException e) {
                    value = appliedVariable.getType().getDefault();
                }
                CompoundTag valueTag = new CompoundTag();
                IValueType valueType = value.getType();
                valueTag.m_128359_("valueType", valueType.getUniqueName().toString());
                valueTag.m_128365_("value", ValueHelpers.serializeRaw(value));
                list.add((Object)valueTag);
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("values", (Tag)list);
            tag.m_128365_("baseOperator", Operators.REGISTRY.serialize(operator.baseOperator));
            return tag;
        }

        @Override
        public CurriedOperator deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag valueOperator) throws EvaluationException {
            CompoundTag tag;
            try {
                tag = (CompoundTag)valueOperator;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                throw new EvaluationException(Component.m_237110_((String)"valuetype.integrateddynamics.error.deserialize", (Object[])new Object[]{valueOperator, e.getMessage()}));
            }
            ListTag list = tag.m_128437_("values", 10);
            IVariable[] variables = new IVariable[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag valuetag = list.m_128728_(i);
                IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(valuetag.m_128461_("valueType")));
                Object value = ValueHelpers.deserializeRaw(valueDeseralizationContext, valueType, valuetag.m_128423_("value"));
                variables[i] = new Variable(valueType, value);
            }
            IOperator baseOperator = Objects.requireNonNull(Operators.REGISTRY.deserialize(valueDeseralizationContext, tag.m_128423_("baseOperator")));
            return new CurriedOperator(baseOperator, variables);
        }
    }
}

