/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.part;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.part.PartOverlayRendererBase;
import org.cyclops.integrateddynamics.part.PartTypeConnectorOmniDirectional;

@OnlyIn(value=Dist.CLIENT)
public class ConnectorOmniPartOverlayRenderer
extends PartOverlayRendererBase {
    private static final Int2IntMap CACHED_GROUP_COLORS = new Int2IntOpenHashMap();
    private final Random rand = new Random();

    protected static int getGroupColor(int group) {
        if (!CACHED_GROUP_COLORS.containsKey(group)) {
            Random rand = new Random(group);
            int color = rand.nextInt(0x800000) | 0xFF000000;
            CACHED_GROUP_COLORS.put(group, color);
            return color;
        }
        return CACHED_GROUP_COLORS.get(group);
    }

    @Override
    public void renderPartOverlay(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay) {
        PartTypeConnectorOmniDirectional.State partState;
        IPartState partStateUnsafe;
        BlockPos pos = partContainer.getPosition().getBlockPos();
        if (!this.shouldRender(pos)) {
            return;
        }
        if (this.rand.nextInt(20) == 0 && !Minecraft.m_91087_().m_91104_() && (partStateUnsafe = partContainer.getPartState(direction)) instanceof PartTypeConnectorOmniDirectional.State && (partState = (PartTypeConnectorOmniDirectional.State)partStateUnsafe).hasConnectorId()) {
            double tx = (float)pos.m_123341_() + 0.5f + (float)direction.m_122429_() * 1.15f - 0.03f + this.rand.nextFloat() * 0.04f + (direction.m_122434_() != Direction.Axis.X ? 0.25f - this.rand.nextFloat() * 0.5f : 0.0f);
            double ty = (float)pos.m_123342_() + 0.5f + (float)direction.m_122430_() * 1.15f - 0.03f + this.rand.nextFloat() * 0.04f + (direction.m_122434_() != Direction.Axis.Y ? 0.25f - this.rand.nextFloat() * 0.5f : 0.0f);
            double tz = (float)pos.m_123343_() + 0.5f + (float)direction.m_122431_() * 1.15f - 0.03f + this.rand.nextFloat() * 0.04f + (direction.m_122434_() != Direction.Axis.Z ? 0.25f - this.rand.nextFloat() * 0.5f : 0.0f);
            float scale = 0.15f;
            Triple colors = Helpers.intToRGB((int)ConnectorOmniPartOverlayRenderer.getGroupColor(partState.getGroupId()));
            float red = ((Float)colors.getLeft()).floatValue() + this.rand.nextFloat() * 0.1f - 0.05f;
            float green = ((Float)colors.getMiddle()).floatValue() + this.rand.nextFloat() * 0.1f - 0.05f;
            float blue = ((Float)colors.getRight()).floatValue() + this.rand.nextFloat() * 0.1f - 0.05f;
            float ageMultiplier = 17.0f;
            Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, tx, ty, tz, (double)(-((float)direction.m_122429_() * 0.05f + this.rand.nextFloat() * 0.02f - 0.01f)), (double)(-((float)direction.m_122430_() * 0.05f + this.rand.nextFloat() * 0.02f - 0.01f)), (double)(-((float)direction.m_122431_() * 0.05f + this.rand.nextFloat() * 0.02f - 0.01f)));
        }
    }
}

