/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.io.IOUtils;

public final class LanguageHandler {
    private LanguageHandler() {
    }

    public static String format(String inputKey, Object ... args) {
        String key = inputKey.toLowerCase(Locale.US);
        String result = args.length == 0 ? Component.m_237115_((String)key).getString() : Component.m_237110_((String)key, (Object[])args).getString();
        return result.isEmpty() ? key : result;
    }

    public static String translateKeyWithFormat(String key, Object ... format) {
        return String.format(LanguageHandler.translateKey(key), format);
    }

    public static String translateKey(String key) {
        return LanguageCache.getInstance().translateKey(key.toLowerCase(Locale.US));
    }

    public static void setMClanguageLoaded() {
        LanguageCache.getInstance().isMCloaded = true;
        LanguageCache.getInstance().languageMap = null;
    }

    public static void loadLangPath(String path) {
        LanguageCache.getInstance().load(path);
    }

    private static class LanguageCache {
        private static final LanguageCache instance = new LanguageCache();
        private boolean isMCloaded = false;
        private Map<String, String> languageMap;

        private LanguageCache() {
            this.load("assets/structurize/lang/%s.json");
        }

        private void load(String path) {
            InputStream is;
            String defaultLocale = "en_us";
            String locale = (String)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_() == null ? null : Minecraft.m_91087_().f_91066_.f_92075_);
            if (locale == null) {
                locale = "en_us";
            }
            if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, locale))) == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, "en_us"));
            }
            this.languageMap = (Map)new Gson().fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), new TypeToken<Map<String, String>>(){}.getType());
            IOUtils.closeQuietly((InputStream)is);
        }

        private static LanguageCache getInstance() {
            return instance;
        }

        private String translateKey(String key) {
            if (this.isMCloaded) {
                return Language.m_128107_().m_6834_(key);
            }
            String res = this.languageMap.get(key);
            return res == null ? Language.m_128107_().m_6834_(key) : res;
        }
    }
}

