/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.util.Tuple;

public abstract class AbstractCommand {
    protected static Commands.CommandSelection getEnvironmentType() {
        return Commands.CommandSelection.ALL;
    }

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        throw new RuntimeException("Missing command builder!");
    }

    protected static LiteralArgumentBuilder<CommandSourceStack> newLiteral(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    protected static <T> RequiredArgumentBuilder<CommandSourceStack, T> newArgument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static void throwSyntaxException(String key) throws CommandSyntaxException {
        throw new CommandSyntaxException((CommandExceptionType)new StructurizeCommandExceptionType(), (Message)new LiteralMessage(LanguageHandler.translateKey(key)));
    }

    public static void throwSyntaxException(String key, Object ... format) throws CommandSyntaxException {
        throw new CommandSyntaxException((CommandExceptionType)new StructurizeCommandExceptionType(), (Message)new LiteralMessage(LanguageHandler.translateKeyWithFormat(key, format)));
    }

    public static class StructurizeCommandExceptionType
    implements CommandExceptionType {
    }

    protected static class CommandTree {
        private final List<CommandTree> childTrees = new ArrayList<CommandTree>();
        private final List<Tuple<Supplier<Commands.CommandSelection>, Supplier<LiteralArgumentBuilder<CommandSourceStack>>>> childNodes = new ArrayList<Tuple<Supplier<Commands.CommandSelection>, Supplier<LiteralArgumentBuilder<CommandSourceStack>>>>();
        private final Commands.CommandSelection buildWhenOn;
        private final String commandName;

        protected static CommandTree newRootNode() {
            return new CommandTree(Commands.CommandSelection.ALL, "structurize");
        }

        protected CommandTree(Commands.CommandSelection environment, String commandName) {
            this.buildWhenOn = environment;
            this.commandName = commandName;
        }

        protected CommandTree addNode(CommandTree tree) {
            this.childTrees.add(tree);
            return this;
        }

        protected CommandTree addNode(Supplier<LiteralArgumentBuilder<CommandSourceStack>> commandBuilder, Supplier<Commands.CommandSelection> commandEnviroment) {
            this.childNodes.add((Tuple<Supplier<Commands.CommandSelection>, Supplier<LiteralArgumentBuilder<CommandSourceStack>>>)new Tuple(commandEnviroment, commandBuilder));
            return this;
        }

        protected Optional<LiteralArgumentBuilder<CommandSourceStack>> build(Commands.CommandSelection environment) {
            if (!this.checkEnvironment(environment, this.buildWhenOn)) {
                return Optional.empty();
            }
            LiteralArgumentBuilder<CommandSourceStack> rootNode = AbstractCommand.newLiteral(this.commandName);
            for (Tuple<Supplier<Commands.CommandSelection>, Supplier<LiteralArgumentBuilder<CommandSourceStack>>> node : this.childNodes) {
                if (!this.checkEnvironment(environment, (Commands.CommandSelection)((Supplier)node.m_14418_()).get())) continue;
                rootNode.then((ArgumentBuilder)((Supplier)node.m_14419_()).get());
            }
            for (CommandTree tree : this.childTrees) {
                Optional<LiteralArgumentBuilder<CommandSourceStack>> builtTree = tree.build(environment);
                if (!builtTree.isPresent()) continue;
                rootNode.then((CommandNode)builtTree.get().build());
            }
            return this.childNodes.isEmpty() && this.childTrees.isEmpty() ? Optional.empty() : Optional.of(rootNode);
        }

        protected void register(CommandDispatcher<CommandSourceStack> commandDispatcher, Commands.CommandSelection serverEnvironmentType) {
            Optional<LiteralArgumentBuilder<CommandSourceStack>> builtTree = this.build(serverEnvironmentType);
            if (builtTree.isPresent()) {
                commandDispatcher.register(builtTree.get());
            }
        }

        private boolean checkEnvironment(Commands.CommandSelection server, Commands.CommandSelection command) {
            return server == Commands.CommandSelection.ALL || command == Commands.CommandSelection.ALL || server == command;
        }
    }
}

