/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.network.messages.OperationHistoryMessage;
import com.ldtteam.structurize.network.messages.UndoRedoMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class WindowUndoRedo
extends AbstractWindowSkeleton {
    public static List<Tuple<String, Integer>> lastOperations = new ArrayList<Tuple<String, Integer>>();
    private final ScrollingList operationsList;

    public WindowUndoRedo() {
        super("structurize:gui/windowundoredo.xml");
        this.registerButton("cancel", this::cancel);
        this.registerButton("undo", (Button b) -> this.undoRedoClicked((Button)b, true));
        this.registerButton("redo", (Button b) -> this.undoRedoClicked((Button)b, false));
        this.operationsList = (ScrollingList)this.findPaneOfTypeByID("operations", ScrollingList.class);
        lastOperations = new ArrayList<Tuple<String, Integer>>();
        if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
            this.close();
        }
    }

    private void undoRedoClicked(Button button, boolean undo) {
        int index = this.operationsList.getListElementIndexByPane((Pane)button);
        Tuple<String, Integer> operation = lastOperations.get(index);
        Network.getNetwork().sendToServer(new UndoRedoMessage((Integer)operation.m_14419_(), undo));
        this.close();
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateOperationsList();
    }

    private void updateOperationsList() {
        this.operationsList.enable();
        this.operationsList.show();
        this.operationsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return lastOperations.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Tuple<String, Integer> resource = lastOperations.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("operationname", Text.class);
                resourceLabel.setText(Component.m_237113_((String)((String)resource.m_14418_())));
                resourceLabel.setColors(WindowScan.WHITE);
                if (((String)resource.m_14418_()).indexOf("undo") == 0) {
                    ((Button)rowPane.findPaneOfTypeByID("redo", Button.class)).hide();
                }
                if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
                    ((Button)rowPane.findPaneOfTypeByID("undo", Button.class)).hide();
                    ((Button)rowPane.findPaneOfTypeByID("redo", Button.class)).hide();
                }
            }
        });
    }

    private void cancel() {
        this.close();
    }

    public void open() {
        super.open();
        this.setVisible(true);
        Network.getNetwork().sendToServer(new OperationHistoryMessage());
    }
}

