/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.fakelevel;

import com.ldtteam.structurize.client.fakelevel.FakeLevel;
import com.ldtteam.structurize.client.fakelevel.IFakeLevelBlockGetter;
import com.ldtteam.structurize.client.fakelevel.IFakeLevelLightProvider;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SingleBlockFakeLevel
extends FakeLevel {
    public SingleBlockFakeLevel(Level realLevel) {
        super(new SingleBlockFakeLevelGetter(), IFakeLevelLightProvider.USE_CLIENT_LEVEL, null, true);
        super.setRealLevel(realLevel);
    }

    @Override
    public SingleBlockFakeLevelGetter getLevelSource() {
        return (SingleBlockFakeLevelGetter)super.getLevelSource();
    }

    public void prepare(BlockState blockState, @Nullable BlockEntity blockEntity, Level realLevel) {
        this.getLevelSource().blockEntity = blockEntity;
        this.getLevelSource().blockState = blockState;
        this.setRealLevel(realLevel);
        if (blockEntity != null) {
            blockEntity.m_142339_((Level)this);
        }
    }

    public void unset(@Nullable BlockEntity blockEntity) {
        this.getLevelSource().blockEntity = null;
        this.getLevelSource().blockState = null;
        this.setRealLevel(null);
        if (blockEntity != null) {
            try {
                blockEntity.m_142339_(null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void withFakeLevelContext(BlockState blockState, @Nullable BlockEntity blockEntity, Level realLevel, Consumer<Level> action) {
        this.prepare(blockState, blockEntity, realLevel);
        action.accept(this);
        this.unset(blockEntity);
    }

    public <T> T useFakeLevelContext(BlockState blockState, @Nullable BlockEntity blockEntity, Level realLevel, Function<Level, T> action) {
        this.prepare(blockState, blockEntity, realLevel);
        T result = action.apply(this);
        this.unset(blockEntity);
        return result;
    }

    public static class SingleBlockFakeLevelGetter
    implements IFakeLevelBlockGetter {
        public BlockState blockState = null;
        public BlockEntity blockEntity = null;

        public BlockEntity m_7702_(BlockPos pos) {
            return this.blockEntity;
        }

        public BlockState m_8055_(BlockPos pos) {
            return this.blockState;
        }

        public int m_141928_() {
            return 1;
        }

        @Override
        public short getSizeX() {
            return 1;
        }

        @Override
        public short getSizeZ() {
            return 1;
        }

        @Override
        public void describeSelfInCrashReport(CrashReportCategory category) {
            category.m_128165_("Single block", () -> ((BlockState)this.blockState).toString());
            category.m_128165_("Single block entity type", () -> this.blockEntity == null ? null : ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.blockEntity.m_58903_()).toString());
        }
    }

    public static class SidedSingleBlockFakeLevel {
        private SingleBlockFakeLevel client;
        private SingleBlockFakeLevel server;

        public SingleBlockFakeLevel get(Level realLevel) {
            if (realLevel.m_5776_()) {
                return this.client != null ? this.client : (this.client = new SingleBlockFakeLevel(realLevel));
            }
            return this.server != null ? this.server : (this.server = new SingleBlockFakeLevel(realLevel));
        }
    }
}

