/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.fakelevel;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.fakelevel.FakeLevel;
import com.ldtteam.structurize.client.fakelevel.IFakeLevelLightProvider;
import com.ldtteam.structurize.util.BlockUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.Scoreboard;

public class BlueprintBlockAccess
extends FakeLevel {
    public static final IFakeLevelLightProvider LIGHT_PROVIDER = new IFakeLevelLightProvider.ConfigBasedLightProvider(Structurize.getConfig().getClient().rendererLightLevel);
    private static final Scoreboard SCOREBOARD = new Scoreboard();
    private BlockState solidSubstitutionOverride = null;
    private boolean renderNice;

    public BlueprintBlockAccess(Blueprint blueprint) {
        super(blueprint, LIGHT_PROVIDER, SCOREBOARD, true);
        this.renderNice = Structurize.getConfig().getClient() != null && (Boolean)Structurize.getConfig().getClient().renderPlaceholdersNice.get() != false;
    }

    private static Level anyLevel() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.m_91091_() ? mc.m_91092_().m_6846_().m_11259_(mc.f_91074_.m_20148_()).m_9236_() : mc.f_91073_;
    }

    @Override
    public BlockState m_8055_(BlockPos pos) {
        return this.prepareBlockStateForRendering(super.m_8055_(pos), pos);
    }

    public BlockState prepareBlockStateForRendering(BlockState state, BlockPos pos) {
        if (this.renderNice) {
            if (state.m_60734_() == ModBlocks.blockSolidSubstitution.get()) {
                if (this.solidSubstitutionOverride != null) {
                    return this.solidSubstitutionOverride;
                }
                return BlockUtils.getSubstitutionBlockAtWorld(BlueprintBlockAccess.anyLevel(), this.worldPos.m_121955_((Vec3i)pos), this.levelSource.getRawBlockStateFunction().compose(b -> b.m_121996_((Vec3i)this.worldPos)));
            }
            if (state.m_60734_() == ModBlocks.blockFluidSubstitution.get()) {
                return BlockUtils.getFluidForDimension(BlueprintBlockAccess.anyLevel());
            }
            if (state.m_60734_() == ModBlocks.blockSubstitution.get()) {
                return Blocks.f_50016_.m_49966_();
            }
            if (state.m_60734_() == ModBlocks.blockTagSubstitution.get()) {
                BlockEntityTagSubstitution tag;
                BlockEntity blockEntity = super.m_7702_(pos);
                if (blockEntity instanceof BlockEntityTagSubstitution && !(tag = (BlockEntityTagSubstitution)blockEntity).getReplacement().isEmpty()) {
                    return tag.getReplacement().getBlockState();
                }
                return Blocks.f_50016_.m_49966_();
            }
        }
        return state;
    }

    public void setSolidSubstitutionOverride(BlockState solidSubstitutionOverride) {
        this.solidSubstitutionOverride = solidSubstitutionOverride;
    }

    public void setRenderBlocksNiceOverride(boolean renderNice) {
        this.renderNice = renderNice;
    }
}

