/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public record FacingFixer(Predicate<BlockState> test, DirectionProperty property, Function<Direction, Direction> mapping) {
    public static final List<FacingFixer> MIRROR_FIXERS = new ArrayList<FacingFixer>();
    public static final FacingFixer GLAZED_TERRACOTA_SPECIAL = FacingFixer.mirrorFixer(bs -> bs.m_60734_() == Blocks.f_50534_ || bs.m_60734_() == Blocks.f_50532_ || bs.m_60734_() == Blocks.f_50537_ || bs.m_60734_() == Blocks.f_50535_, GlazedTerracottaBlock.f_54117_, FacingMapping.SOUTH_EAST_AND_NORTH_WEST);
    public static final FacingFixer GLAZED_TERRACOTA_MAJORITY = FacingFixer.mirrorFixer(bs -> bs.m_60734_() instanceof GlazedTerracottaBlock && bs.m_60734_() != Blocks.f_50528_, GlazedTerracottaBlock.f_54117_, FacingMapping.NORTH_EAST_AND_SOUTH_WEST);

    public static FacingFixer mirrorFixer(Predicate<BlockState> test, DirectionProperty property, Function<Direction, Direction> mapping) {
        FacingFixer result = new FacingFixer(test, property, mapping);
        MIRROR_FIXERS.add(result);
        return result;
    }

    public static BlockState fixMirroredFacing(BlockState blockstate, BlockState unmirrored) {
        for (FacingFixer fixer : MIRROR_FIXERS) {
            if (!fixer.test.test(blockstate)) continue;
            return (BlockState)blockstate.m_61124_((Property)fixer.property, (Comparable)fixer.mapping.apply((Direction)unmirrored.m_61143_((Property)fixer.property)));
        }
        return blockstate;
    }

    public record FacingMapping(Direction north, Direction east, Direction south, Direction west, Direction up, Direction down) implements Function<Direction, Direction>
    {
        public static final FacingMapping NORTH_EAST_AND_SOUTH_WEST = new FacingMapping(Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH);
        public static final FacingMapping SOUTH_EAST_AND_NORTH_WEST = new FacingMapping(Direction.WEST, Direction.SOUTH, Direction.EAST, Direction.NORTH);
        public static final FacingMapping KEEP_ORIGINAL = new FacingMapping(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);

        public FacingMapping(Direction north, Direction east, Direction south, Direction west) {
            this(north, east, south, west, Direction.UP, Direction.DOWN);
        }

        @Override
        public Direction apply(Direction direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.NORTH -> this.north;
                case Direction.EAST -> this.east;
                case Direction.SOUTH -> this.south;
                case Direction.WEST -> this.west;
                case Direction.UP -> this.up;
                case Direction.DOWN -> this.down;
            };
        }
    }
}

