/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.sensor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineReader;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorTypeData;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.functional.NonNullToIntFunction;
import java.util.List;
import net.minecraftforge.fml.LogicalSide;

public enum TurbineSensorType implements ISensorType<ITurbineReader>,
IDebuggable
{
    Disabled(SensorBehavior.Disabled),
    inputActive(SensorBehavior.SetFromSignal, SensorBehavior.ToggleOnPulse),
    inputEngageCoils(SensorBehavior.SetFromSignal, SensorBehavior.ToggleOnPulse),
    inputFlowRegulator(SensorBehavior.SetFromSignal, SensorBehavior.SetFromSignalLevel, SensorBehavior.SetOnPulse, SensorBehavior.AugmentOnPulse, SensorBehavior.ReduceOnPulse),
    outputRotorSpeed((NonNullToIntFunction<ITurbineReader>)((NonNullToIntFunction)r -> (int)r.getRotorSpeed()), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputEnergyAmount((NonNullToIntFunction<ITurbineReader>)((NonNullToIntFunction)r -> (int)(r.getEnergyStoredPercentage() * 100.0)), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputCoolantAmount((NonNullToIntFunction<ITurbineReader>)((NonNullToIntFunction)ITurbineReader::getCoolantAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputVaporAmount((NonNullToIntFunction<ITurbineReader>)((NonNullToIntFunction)ITurbineReader::getVaporAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween);

    private final SensorTypeData<ITurbineReader> _data;
    private final String _translationBaseName;

    private TurbineSensorType(SensorBehavior ... behaviors) {
        this((SensorTypeData<ITurbineReader>)SensorTypeData.input((SensorBehavior[])behaviors));
    }

    private TurbineSensorType(NonNullToIntFunction<ITurbineReader> outputSupplier, SensorBehavior ... behaviors) {
        this((SensorTypeData<ITurbineReader>)SensorTypeData.output(outputSupplier, (SensorBehavior[])behaviors));
    }

    public boolean isDisabled() {
        return Disabled == this;
    }

    public boolean isInput() {
        return this._data.isInput();
    }

    public boolean isOutput() {
        return this._data.isOutput();
    }

    public List<SensorBehavior> getBehaviors() {
        return this._data.getBehaviors();
    }

    public int applyAsInt(ITurbineReader reader) {
        return this._data.applyAsInt((IMachineReader)reader);
    }

    public String getTranslationBaseName() {
        return this._translationBaseName;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Turbine Sensor Type: %1$s", new Object[]{this});
    }

    private TurbineSensorType(SensorTypeData<ITurbineReader> _data) {
        this._data = _data;
        this._translationBaseName = "gui.bigreactors.turbine.redstoneport.sensortype." + CodeHelper.neutralLowercase((String)this.name());
    }
}

