/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.container.FluidPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.FluidPortType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPortHandler;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurbineFluidPortEntity
extends AbstractTurbineEntity
implements IFluidPort,
INeighborChangeListener,
MenuProvider {
    private final IFluidPortHandler _handler;
    private IoDirection _direction;

    public TurbineFluidPortEntity(FluidPortType type, IoMode mode, BlockEntityType<?> entityType, BlockPos position, BlockState blockState) {
        super(entityType, position, blockState);
        this._handler = FluidPortType.create(type, mode, this);
        this.setIoDirection(IoDirection.Input);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).build((AbstractModBlockEntity)this));
    }

    public IFluidPortHandler getFluidPortHandler() {
        return this._handler;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        if (this.isConnected()) {
            this.getFluidPortHandler().checkConnections(this.m_58904_(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        if (this.isConnected()) {
            this.getFluidPortHandler().checkConnections(this.m_58904_(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public IoDirection getIoDirection() {
        return this._direction;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._direction = direction;
        this.getFluidPortHandler().update(this::getUpdatedHandler);
        this.executeOnController(MultiblockTurbine::onFluidPortChanged);
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.m_6596_();
        }, () -> ((TurbineFluidPortEntity)this).markForRenderUpdate());
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.setIoDirection(IoDirection.read((CompoundTag)data, (String)"iodir", (IoDirection)IoDirection.Input));
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        IoDirection.write((CompoundTag)data, (String)"iodir", (IoDirection)this.getIoDirection());
        return data;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new FluidPortContainer(windowId, (MenuType)Content.ContainerTypes.TURBINE_FLUIDPORT.get(), inventory, this);
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int connectedOffset = this.isMachineAssembled() && this.getFluidPortHandler().isConnected() ? 1 : 0;
        return this.getIoDirection().isInput() ? 2 + connectedOffset : connectedOffset;
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    public void onPostMachineAssembled(MultiblockTurbine controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
        this.notifyOutwardNeighborsOfStateChange();
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.getFluidPortHandler().update(this::getUpdatedHandler);
        this.notifyOutwardNeighborsOfStateChange();
    }

    public void onAttached(MultiblockTurbine newController) {
        super.onAttached((IMultiblockController)newController);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
    }

    public void onAssimilated(MultiblockTurbine newController) {
        super.onAssimilated((IMultiblockController)newController);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
    }

    public void onDetached(MultiblockTurbine oldController) {
        super.onDetached((IMultiblockController)oldController);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        LazyOptional cap = this.getFluidPortHandler().getCapability(capability, side);
        return null != cap ? cap : super.getCapability(capability, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.getFluidPortHandler().invalidate();
    }

    private IFluidHandler getUpdatedHandler(IoDirection direction) {
        return (IFluidHandler)this.getMultiblockController().flatMap(c -> c.getFluidHandler(direction)).orElse(EmptyFluidHandler.INSTANCE);
    }
}

