/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.container.FluidizerSolidInjectorContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.AbstractFluidizerEntity;
import it.zerono.mods.zerocore.base.BaseHelper;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.ingredient.RecipeIngredientSourceWrapper;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidizerSolidInjectorEntity
extends AbstractFluidizerEntity
implements MenuProvider,
INeighborChangeListener,
IConditionallySyncableEntity {
    private static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    private static final ResourceLocation SYNC_DATA_ID = ExtremeReactors.ROOT_LOCATION.buildWithSuffix("solidinjector");
    private final ItemStackHolder _solidItems = (ItemStackHolder)((ItemStackHolder)new ItemStackHolder(1, ($, stack) -> this.isValidIngredient((ItemStack)stack)).setOnLoadListener(this::onItemsChanged)).setOnContentsChangedListener(this::onItemsChanged);
    private final LazyOptional<IItemHandlerModifiable> _capability = LazyOptional.of(() -> this._solidItems);
    private boolean _shouldSync;

    public FluidizerSolidInjectorEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.FLUIDIZER_SOLIDINJECTOR.get(), position, blockState);
    }

    public IRecipeIngredientSource<ItemStack> asRecipeSource() {
        return RecipeIngredientSourceWrapper.wrap((IItemHandler)this._solidItems, (int)0);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this._solidItems;
    }

    public ItemStack getStack() {
        return this._solidItems.getStackAt(0);
    }

    public boolean isValidIngredient(ItemStack stack) {
        return (Boolean)this.evalOnController(c -> c.isValidIngredient(stack), false);
    }

    public static void itemTooltipBuilder(ItemStack stack, CompoundTag data, @Nullable BlockGetter world, NonNullConsumer<Component> appender, boolean isAdvancedTooltip) {
        if (data.m_128441_("inv")) {
            ItemStackHolder holder = new ItemStackHolder(1);
            holder.syncDataFrom(data.m_128469_("inv"), ISyncableEntity.SyncReason.FullSync);
            MutableComponent text = holder.isEmpty(0) ? BaseHelper.emptyValue() : Component.m_237110_((String)"gui.bigreactors.reactor.fluidaccessport.item.reactant", (Object[])new Object[]{ItemHelper.getItemName((ItemStack)holder.getStackInSlot(0)), holder.getAmount(0)});
            appender.accept((Object)Component.m_237115_((String)"gui.bigreactors.generic.fuel.label").m_7220_((Component)text.m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE)));
        }
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return this.isMachineAssembled() && this.getNeighborCapability().isPresent() ? 1 : 0;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        this.requestClientRenderUpdate();
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._solidItems, "inv", data, syncReason);
        if (syncReason.isFullSync()) {
            this._shouldSync = true;
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._solidItems, "inv", data, syncReason);
        return data;
    }

    public ResourceLocation getSyncableEntityId() {
        return SYNC_DATA_ID;
    }

    public boolean shouldSyncEntity() {
        boolean result = this._shouldSync;
        this._shouldSync = false;
        return result;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        messages.add((Object)this._solidItems, DebuggableHelper::getDebugMessagesFor, "Items");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new FluidizerSolidInjectorContainer(windowId, inventory, this);
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ITEM_HANDLER_CAPABILITY == cap ? this._capability.cast() : super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this._capability.invalidate();
    }

    private LazyOptional<IItemHandler> getNeighborCapability() {
        return CodeHelper.optionalFlatMap((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (world, direction) -> WorldHelper.getTile((Level)world, (BlockPos)this.getWorldPosition().m_121945_(direction)).map(te -> te.getCapability(ITEM_HANDLER_CAPABILITY, direction.m_122424_()))).orElse(LazyOptional.empty());
    }

    private void onItemsChanged() {
        this.onItemsChanged(IStackHolder.ChangeType.Replaced, 0);
    }

    private void onItemsChanged(IStackHolder.ChangeType changeType, int slot) {
        this.m_6596_();
        this.onIngredientsChanged(changeType);
        this._shouldSync = true;
    }
}

