/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.coolant;

import it.zerono.mods.extremereactors.api.internal.AbstractNamedValue;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;

public class Coolant
extends AbstractNamedValue {
    public static final Coolant EMPTY = new Coolant("empty", Colour.WHITE, Float.MAX_VALUE, 0.0f, "gui.zerocore.base.generic.empty");
    private final float _boilingPoint;
    private final float _enthalpyOfVaporization;
    private final Colour _colour;

    Coolant(String name, Colour colour, float boilingPoint, float enthalpyOfVaporization, String translationKey) {
        super(name, translationKey);
        this._boilingPoint = Math.max(0.0f, boilingPoint);
        this._enthalpyOfVaporization = Math.max(0.0f, enthalpyOfVaporization);
        this._colour = colour;
    }

    public float getBoilingPoint() {
        return this._boilingPoint;
    }

    public float getEnthalpyOfVaporization() {
        return this._enthalpyOfVaporization;
    }

    public Coolant copy() {
        return new Coolant(this.getName(), this.getColour(), this.getBoilingPoint(), this.getEnthalpyOfVaporization(), this.getTranslationKey());
    }

    public Colour getColour() {
        return this._colour;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Coolant && super.equals(obj) && this.getBoilingPoint() == ((Coolant)obj).getBoilingPoint() && this.getEnthalpyOfVaporization() == ((Coolant)obj).getEnthalpyOfVaporization();
    }
}

