/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.registry;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import tech.thatgravyboat.creeperoverhaul.common.config.SpawningConfig;
import tech.thatgravyboat.creeperoverhaul.common.entity.CreeperTypes;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModEntities;
import tech.thatgravyboat.creeperoverhaul.common.registry.forge.ModSpawnsImpl;

public class ModSpawns {
    public static void addSpawnRules() {
        ModSpawns.register(ModEntities.JUNGLE_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ModSpawns.getPredicate(CreeperTypes.JUNGLE, ModSpawns::checkMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.BAMBOO_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ModSpawns.getPredicate(CreeperTypes.BAMBOO, ModSpawns::checkDayMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.DESERT_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.DESERT, ModSpawns::checkMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.BADLANDS_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.BADLANDS, ModSpawns::checkMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.HILLS_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.HILLS, ModSpawns::checkMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.SAVANNAH_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.SAVANNAH, ModSpawns::checkMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.MUSHROOM_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.MUSHROOM, ModSpawns::checkDayMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.SWAMP_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.SWAMP, ModSpawns::checkMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.DRIPSTONE_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.DRIPSTONE, ModSpawns::checkMonsterSpawnRulesCave));
        ModSpawns.register(ModEntities.CAVE_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.CAVE, ModSpawns::checkMonsterSpawnRulesCave));
        ModSpawns.register(ModEntities.DARK_OAK_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.DARK_OAK, ModSpawns::checkMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.SPRUCE_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.SPRUCE, ModSpawns::checkMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.BEACH_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.BEACH, ModSpawns::checkMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.SNOWY_CREEPER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.SNOWY, ModSpawns::checkDayMonsterSpawnRulesAbove));
        ModSpawns.register(ModEntities.OCEAN_CREEPER, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.OCEAN, ModSpawns::checkWaterSpawnRules));
    }

    public static <T extends Mob> SpawnPlacements.SpawnPredicate<T> getPredicate(CreeperType creeper, SpawnPlacements.SpawnPredicate<T> predicate) {
        return (type, level, reason, pos, random) -> creeper.canSpawn().getAsBoolean() && SpawningConfig.allowSpawning && predicate.m_217080_(type, level, reason, pos, random);
    }

    public static boolean checkMonsterSpawnRulesCave(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pPos.m_123342_() < pLevel.m_5736_() && !pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50440_) && pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && Monster.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkMonsterSpawnRulesAbove(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pPos.m_123342_() > pLevel.m_5736_() && pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && Monster.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkWaterSpawnRules(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public static boolean checkDayMonsterSpawnRulesAbove(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        BlockState state = pLevel.m_8055_(pPos.m_7495_());
        boolean isGrassLike = state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50599_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50493_);
        return pPos.m_123342_() > pLevel.m_5736_() && pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom) && (isGrassLike || state.m_204336_(BlockTags.f_13061_) || state.m_60734_() instanceof LeavesBlock);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Mob> void register(Supplier<EntityType<T>> entityType, SpawnPlacements.Type type, Heightmap.Types types, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
        void var3_3;
        void var2_2;
        void var1_1;
        ModSpawnsImpl.register(entityType, (SpawnPlacements.Type)var1_1, (Heightmap.Types)var2_2, var3_3);
    }
}

