/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.input;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.entity.forge.input.HephaestusForgeInput;
import com.stal111.forbidden_arcanus.common.block.entity.forge.input.HephaestusForgeInputType;
import com.stal111.forbidden_arcanus.core.init.other.ModForgeInputTypes;
import com.stal111.forbidden_arcanus.util.AdditionalCodecs;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemInput
extends HephaestusForgeInput {
    public static final Codec<ItemInput> CODEC = RecordCodecBuilder.create(instance -> instance.group(ItemInput.essenTypeCodec(), (App)AdditionalCodecs.INGREDIENT.fieldOf("item").forGetter(input -> input.ingredient), (App)Codec.INT.optionalFieldOf("amount").forGetter(input -> Optional.of(input.amount))).apply((Applicative)instance, (type, name, amount) -> new ItemInput((List<EssenceType>)type, (Ingredient)name, (int)amount.orElse(1))));
    private final Ingredient ingredient;
    private final int amount;

    public ItemInput(EssenceType essenceType, Ingredient ingredient, int amount) {
        super(essenceType);
        this.ingredient = ingredient;
        this.amount = amount;
    }

    public ItemInput(List<EssenceType> essenceTypes, Ingredient ingredient, int amount) {
        super(essenceTypes);
        this.ingredient = ingredient;
        this.amount = amount;
    }

    @Override
    public boolean canInputStack(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Override
    public int getInputValue(EssenceType inputType, ItemStack stack, RandomSource random) {
        return this.amount;
    }

    @Override
    public void finishInput(EssenceType inputType, ItemStack stack, HephaestusForgeBlockEntity tileEntity, int slot, int inputValue) {
        stack.m_41774_(1);
    }

    @Override
    public HephaestusForgeInputType<?> type() {
        return (HephaestusForgeInputType)ModForgeInputTypes.SIMPLE_ITEM.get();
    }
}

