/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class GasHelper {
    @Nonnull
    public static Optional<IGasHandler> handler(@Nullable ICapabilityProvider provider, @Nullable Direction direction) {
        if (provider == null) {
            return Optional.empty();
        }
        if (Capabilities.GAS_HANDLER != null && provider.getCapability(Capabilities.GAS_HANDLER, direction).isPresent()) {
            return Optional.of((IGasHandler)provider.getCapability(Capabilities.GAS_HANDLER, direction).orElseThrow(() -> new IllegalArgumentException("IGasHandler is 'null' even though it said that its present")));
        }
        if (direction != null && provider instanceof IGasHandler.ISidedGasHandler && ((IGasHandler.ISidedGasHandler)provider).getTanks(direction) >= 1) {
            return Optional.of((IGasHandler)provider);
        }
        if (!(provider instanceof IGasHandler.ISidedGasHandler) && provider instanceof IGasHandler && ((IGasHandler)provider).getTanks() >= 1) {
            return Optional.of((IGasHandler)provider);
        }
        return Optional.empty();
    }

    @Nonnull
    public static GasStack insert(IGasHandler handler, GasStack stack, @Nullable Direction direction, Action action) {
        if (handler instanceof IGasHandler.ISidedGasHandler) {
            return (GasStack)((IGasHandler.ISidedGasHandler)handler).insertChemical((ChemicalStack)stack, direction, action);
        }
        return (GasStack)handler.insertChemical((ChemicalStack)stack, action);
    }

    @Nonnull
    public static GasStack extract(IGasHandler handler, long amount, @Nullable Direction direction, Action action) {
        if (handler instanceof IGasHandler.ISidedGasHandler) {
            return (GasStack)((IGasHandler.ISidedGasHandler)handler).extractChemical(amount, direction, action);
        }
        return (GasStack)handler.extractChemical(amount, action);
    }

    public static List<Gas> chemicalInTank(@Nonnull IGasHandler handler, @Nullable Direction direction) {
        ArrayList<Gas> gases = new ArrayList<Gas>();
        if (handler instanceof IGasHandler.ISidedGasHandler) {
            for (int i = 0; i < ((IGasHandler.ISidedGasHandler)handler).getTanks(direction); ++i) {
                Gas gas = (Gas)((GasStack)((IGasHandler.ISidedGasHandler)handler).getChemicalInTank(i, direction)).getType();
                if (gas.isEmptyType()) continue;
                gases.add(gas);
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                Gas gas = (Gas)((GasStack)handler.getChemicalInTank(i)).getType();
                if (gas.isEmptyType()) continue;
                gases.add(gas);
            }
        }
        return gases;
    }

    public static List<Gas> chemicalInTank(@Nonnull IGasHandler handler) {
        return GasHelper.chemicalInTank(handler, null);
    }

    public static long amountInTank(@Nonnull IGasHandler handler, @Nullable Direction direction, @Nullable Predicate<GasStack> filter) {
        long count = 0L;
        if (handler instanceof IGasHandler.ISidedGasHandler) {
            for (int i = 0; i < ((IGasHandler.ISidedGasHandler)handler).getTanks(direction); ++i) {
                GasStack stack = (GasStack)((IGasHandler.ISidedGasHandler)handler).getChemicalInTank(i, direction);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                GasStack stack = (GasStack)handler.getChemicalInTank(i);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        }
        return count;
    }

    public static long amountInTank(@Nonnull IGasHandler handler, @Nullable Direction direction, @Nullable Gas filter) {
        return GasHelper.amountInTank(handler, direction, (GasStack stack) -> filter == null || stack.getType() == filter);
    }

    public static long amountInTank(@Nonnull IGasHandler handler, @Nullable Direction direction, @Nullable GasStack filter) {
        return GasHelper.amountInTank(handler, direction, (GasStack stack) -> filter == null || stack.isTypeEqual((ChemicalStack)filter));
    }

    public static long amountInTank(@Nonnull IGasHandler handler, @Nullable Direction direction) {
        return GasHelper.amountInTank(handler, direction, (Predicate<GasStack>)null);
    }

    public static long amountInTank(@Nonnull IGasHandler handler) {
        return GasHelper.amountInTank(handler, null);
    }
}

