/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.api.xnet.tiles.IConnectorTile;
import mcjty.xnet.apiimpl.ConnectedEntity;
import mcjty.xnet.apiimpl.enums.InsExtMode;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.setup.Config;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import terrails.xnetgases.Constants;
import terrails.xnetgases.helper.BaseChannelSettings;
import terrails.xnetgases.helper.ModuleEnums;
import terrails.xnetgases.module.chemical.ChemicalConnectorSettings;
import terrails.xnetgases.module.chemical.ChemicalEnums;
import terrails.xnetgases.module.chemical.utils.ChemicalHelper;

public class ChemicalChannelSettings
extends BaseChannelSettings {
    public static final String TAG_DELAY = "delay";
    public static final String TAG_DISTRIBUTE_OFFSET = "distribute_offset";
    private ModuleEnums.ChannelMode channelMode = ModuleEnums.ChannelMode.DISTRIBUTE;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private List<ConnectedEntity<ChemicalConnectorSettings>> extractors;
    private List<ConnectedEntity<ChemicalConnectorSettings>> consumers;

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.channelMode = ModuleEnums.ChannelMode.values()[tag.m_128445_("mode")];
        this.delay = tag.m_128451_(TAG_DELAY);
        this.roundRobinOffset = tag.m_128451_(TAG_DISTRIBUTE_OFFSET);
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        tag.m_128344_("mode", (byte)this.channelMode.ordinal());
        tag.m_128405_(TAG_DELAY, this.delay);
        tag.m_128405_(TAG_DISTRIBUTE_OFFSET, this.roundRobinOffset);
    }

    @Override
    public void readFromJson(JsonObject data) {
        this.channelMode = ModuleEnums.ChannelMode.byName(data.get("mode").getAsString());
        this.delay = data.get(TAG_DELAY).getAsInt();
        this.roundRobinOffset = data.get(TAG_DISTRIBUTE_OFFSET).getAsInt();
    }

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add("mode", (JsonElement)new JsonPrimitive(this.channelMode.name()));
        object.add(TAG_DELAY, (JsonElement)new JsonPrimitive((Number)this.delay));
        object.add(TAG_DISTRIBUTE_OFFSET, (JsonElement)new JsonPrimitive((Number)this.roundRobinOffset));
        return object;
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 != 0) {
            return;
        }
        this.updateCache(channel, context);
        Level world = context.getControllerWorld();
        for (ConnectedEntity<ChemicalConnectorSettings> extractor : this.extractors) {
            ChemicalConnectorSettings settings = (ChemicalConnectorSettings)((Object)extractor.settings());
            if (this.delay % settings.getOperationSpeed() != 0 || !LevelTools.isLoaded((Level)world, (BlockPos)extractor.getBlockPos())) continue;
            if (!this.checkRedstone(settings, (IConnectorTile)extractor.getConnectorEntity(), context)) {
                return;
            }
            BlockEntity be = extractor.getConnectedEntity();
            ChemicalEnums.Type type = settings.getConnectorType();
            IChemicalHandler handler = ChemicalHelper.handler((ICapabilityProvider)be, settings.getFacing(), type).orElse(null);
            if (handler == null) continue;
            this.tickGasHandler(context, settings, handler);
        }
    }

    private void tickGasHandler(IControllerContext context, ChemicalConnectorSettings settings, IChemicalHandler<?, ?> handler) {
        ChemicalStack<?> extractStack;
        long remaining;
        if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) {
            return;
        }
        ChemicalEnums.Type type = settings.getConnectorType();
        ChemicalStack<?> filter = settings.getMatcher();
        long amount = ChemicalHelper.amountInTank(handler, settings.getFacing(), filter, type);
        if (amount <= 0L) {
            return;
        }
        long toExtract = settings.getRate();
        Integer count = settings.getMinMaxLimit();
        if (count != null) {
            long canExtract = amount - (long)count.intValue();
            if (canExtract <= 0L) {
                return;
            }
            toExtract = Math.min(toExtract, canExtract);
        }
        do {
            if ((extractStack = ChemicalHelper.extract(handler, toExtract, settings.getFacing(), Action.SIMULATE, type)).isEmpty() || filter != null && filter.getType() != extractStack.getType()) {
                return;
            }
            toExtract = extractStack.getAmount();
        } while ((remaining = this.insertGas(context, extractStack, type)) == (toExtract -= remaining));
        ChemicalHelper.extract(handler, toExtract, settings.getFacing(), Action.EXECUTE, type);
    }

    private long insertGas(IControllerContext context, ChemicalStack<?> stack, ChemicalEnums.Type type) {
        Level level = context.getControllerWorld();
        if (this.channelMode == ModuleEnums.ChannelMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        long amount = stack.getAmount();
        int currentRoundRobinOffset = this.roundRobinOffset;
        for (int j = 0; j < this.consumers.size(); ++j) {
            BlockEntity be;
            IChemicalHandler handler;
            int i = (j + currentRoundRobinOffset) % this.consumers.size();
            ConnectedEntity<ChemicalConnectorSettings> consumer = this.consumers.get(i);
            ChemicalConnectorSettings settings = (ChemicalConnectorSettings)((Object)consumer.settings());
            if (settings.getConnectorType() != type || settings.getMatcher() != null && settings.getMatcher().getType() != stack.getType() || !LevelTools.isLoaded((Level)level, (BlockPos)consumer.getBlockPos()) || !this.checkRedstone(settings, (IConnectorTile)consumer.getConnectorEntity(), context) || (handler = (IChemicalHandler)ChemicalHelper.handler((ICapabilityProvider)(be = consumer.getConnectedEntity()), settings.getFacing(), settings.getConnectorType()).orElse(null)) == null) continue;
            long toInsert = Math.min((long)settings.getRate(), amount);
            Integer count = settings.getMinMaxLimit();
            if (count != null) {
                long a = ChemicalHelper.amountInTank(handler, settings.getFacing(), settings.getMatcher(), settings.getConnectorType());
                long canInsert = (long)count.intValue() - a;
                if (canInsert <= 0L) continue;
                toInsert = Math.min(toInsert, canInsert);
            }
            if (settings.isTransferRateRequired() && (long)settings.getRate() > toInsert) continue;
            ChemicalStack copy = stack.copy();
            copy.setAmount(toInsert);
            ChemicalStack<?> remaining = ChemicalHelper.insert(handler, copy, settings.getFacing(), Action.EXECUTE, settings.getConnectorType());
            if (!remaining.isEmpty() && (remaining.isEmpty() || copy.getAmount() == remaining.getAmount())) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.consumers.size();
            if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
            return 0L;
        }
        return amount;
    }

    @Override
    public void cleanCache() {
        this.extractors = null;
        this.consumers = null;
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.extractors == null) {
            ConnectedEntity<ChemicalConnectorSettings> connectedEntity;
            ChemicalConnectorSettings settings;
            this.extractors = new ArrayList<ConnectedEntity<ChemicalConnectorSettings>>();
            this.consumers = new ArrayList<ConnectedEntity<ChemicalConnectorSettings>>();
            Level world = context.getControllerWorld();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                connectedEntity = this.getConnectedEntityInfo(context, entry, world, settings = (ChemicalConnectorSettings)((Object)entry.getValue()));
                if (connectedEntity == null) continue;
                if (settings.getConnectorMode() == InsExtMode.EXT) {
                    this.extractors.add(connectedEntity);
                    continue;
                }
                this.consumers.add(connectedEntity);
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                connectedEntity = this.getConnectedEntityInfo(context, entry, world, settings = (ChemicalConnectorSettings)((Object)entry.getValue()));
                if (connectedEntity == null || settings.getConnectorMode() != InsExtMode.INS) continue;
                this.consumers.add(connectedEntity);
            }
            this.consumers.sort((o1, o2) -> Integer.compare(((ChemicalConnectorSettings)((Object)((Object)((Object)o2.settings())))).getPriority(), ((ChemicalConnectorSettings)((Object)((Object)((Object)o1.settings())))).getPriority()));
        }
    }

    @javax.annotation.Nullable
    private ConnectedEntity<ChemicalConnectorSettings> getConnectedEntityInfo(IControllerContext context, Map.Entry<SidedConsumer, IConnectorSettings> entry, @Nonnull Level world, @Nonnull ChemicalConnectorSettings con) {
        BlockPos connectorPos = context.findConsumerPosition(entry.getKey().consumerId());
        if (connectorPos == null) {
            return null;
        }
        ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)world.m_7702_(connectorPos);
        if (connectorTileEntity == null) {
            return null;
        }
        BlockPos connectedBlockPos = connectorPos.m_121945_(entry.getKey().side());
        BlockEntity connectedEntity = world.m_7702_(connectedBlockPos);
        if (connectedEntity == null) {
            return null;
        }
        return new ConnectedEntity(entry.getKey(), (Object)con, connectorPos, connectedBlockPos, connectedEntity, connectorTileEntity);
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 90, 11, 10);
    }

    @Override
    public void createGui(IEditorGui gui) {
        gui.nl().translatableChoices("mode", (ITranslatableEnum)this.channelMode, (ITranslatableEnum[])ModuleEnums.ChannelMode.values());
    }

    @Override
    public boolean isEnabled(String s) {
        return true;
    }

    @Override
    public void update(Map<String, Object> map) {
        this.channelMode = ChemicalHelper.safeChannelMode(map.get("mode"));
    }
}

