/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import com.google.common.base.Strings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import shetiphian.platforms.Roster;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.block.BlockPlatformRoof;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class TileEntityPlatformRoof
extends TileEntityPlatformBase {
    private byte support = 0;
    private String edgeType = null;
    public Direction preRotateFacing;

    public TileEntityPlatformRoof(BlockPos pos, BlockState state) {
        super((BlockEntityType)Roster.Tiles.ROOF.get(), pos, state);
    }

    @Override
    protected void buildNBT(CompoundTag nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.m_128344_("support", this.support);
        if (!Strings.isNullOrEmpty((String)this.edgeType)) {
            nbtTag.m_128359_("edge_type", this.edgeType);
        }
    }

    @Override
    protected void processNBT(CompoundTag nbtTag) {
        super.processNBT(nbtTag);
        this.support = nbtTag.m_128445_("support");
        this.edgeType = nbtTag.m_128441_("edge_type") ? nbtTag.m_128461_("edge_type") : null;
    }

    public byte getSupport() {
        return this.support;
    }

    public void setSupport(int support) {
        this.support = (byte)Mth.m_14045_((int)support, (int)0, (int)5);
    }

    public void m_155250_(BlockState state) {
        Block block;
        super.m_155250_(state);
        if (this.f_58857_ != null && (block = state.m_60734_()) instanceof BlockPlatformBase) {
            Direction direction = (Direction)state.m_61143_((Property)BlockPlatformBase.FACING);
            this.f_58857_.m_46586_(this.f_58858_.m_7494_().m_121945_(direction), block, this.f_58858_);
            this.f_58857_.m_46586_(this.f_58858_.m_7495_().m_121945_(direction.m_122424_()), block, this.f_58858_);
            if (this.preRotateFacing != null && direction != this.preRotateFacing) {
                this.f_58857_.m_46586_(this.f_58858_.m_7494_().m_121945_(this.preRotateFacing), block, this.f_58858_);
                this.f_58857_.m_46586_(this.f_58858_.m_7495_().m_121945_(this.preRotateFacing.m_122424_()), block, this.f_58858_);
            }
            this.preRotateFacing = null;
        }
    }

    public Direction updateEdgeType(EnumSubType.EnumStyle style, Direction facing) {
        if (this.f_58857_ == null) {
            return null;
        }
        if (style == EnumSubType.EnumStyle.EDGE) {
            Direction direction = null;
            boolean north = this.isRoofEdge(Direction.NORTH);
            boolean south = this.isRoofEdge(Direction.SOUTH);
            boolean east = this.isRoofEdge(Direction.EAST);
            boolean west = this.isRoofEdge(Direction.WEST);
            int connections = (north ? 1 : 0) + (south ? 1 : 0) + (east ? 1 : 0) + (west ? 1 : 0);
            switch (connections) {
                case 0: 
                case 1: {
                    boolean conR;
                    boolean ew;
                    BlockPos downPos = this.f_58858_.m_7495_();
                    EnumSubType.EnumStyle cN = this.isConnectedRoof(downPos, Direction.NORTH, true);
                    EnumSubType.EnumStyle cS = this.isConnectedRoof(downPos, Direction.SOUTH, true);
                    EnumSubType.EnumStyle cE = this.isConnectedRoof(downPos, Direction.EAST, true);
                    EnumSubType.EnumStyle cW = this.isConnectedRoof(downPos, Direction.WEST, true);
                    boolean left = cN == EnumSubType.EnumStyle.LEFT && cS == EnumSubType.EnumStyle.RIGHT || cE == EnumSubType.EnumStyle.LEFT && cW == EnumSubType.EnumStyle.RIGHT;
                    boolean right = cN == EnumSubType.EnumStyle.RIGHT && cS == EnumSubType.EnumStyle.LEFT || cE == EnumSubType.EnumStyle.RIGHT && cW == EnumSubType.EnumStyle.LEFT;
                    boolean ns = cN == EnumSubType.EnumStyle.MIDDLE && cS == EnumSubType.EnumStyle.MIDDLE;
                    boolean bl = ew = cE == EnumSubType.EnumStyle.MIDDLE && cW == EnumSubType.EnumStyle.MIDDLE;
                    if (left || right) {
                        this.edgeType = "sides";
                        direction = cS == EnumSubType.EnumStyle.LEFT ? Direction.NORTH : (cW == EnumSubType.EnumStyle.LEFT ? Direction.EAST : (cN == EnumSubType.EnumStyle.LEFT ? Direction.SOUTH : Direction.WEST));
                    } else if (!(east || west || ns || cN != EnumSubType.EnumStyle.MIDDLE && cS != EnumSubType.EnumStyle.MIDDLE)) {
                        this.edgeType = "end";
                        direction = cN == EnumSubType.EnumStyle.MIDDLE ? Direction.EAST : Direction.WEST;
                    } else if (!(north || south || ew || cE != EnumSubType.EnumStyle.MIDDLE && cW != EnumSubType.EnumStyle.MIDDLE)) {
                        this.edgeType = "end";
                        direction = cW == EnumSubType.EnumStyle.MIDDLE ? Direction.NORTH : Direction.SOUTH;
                    } else if (connections == 1) {
                        this.edgeType = "middle";
                        direction = north || south ? Direction.EAST : Direction.NORTH;
                    } else {
                        String string = this.edgeType = ns != ew ? "middle" : "cap";
                        Direction direction2 = ns == ew ? Direction.NORTH : (direction = ns ? Direction.NORTH : Direction.EAST);
                    }
                    if (!this.edgeType.equals("middle")) break;
                    boolean conL = this.isConnectedRoof(this.f_58858_, direction.m_122427_(), false) == EnumSubType.EnumStyle.MIDDLE;
                    boolean bl2 = conR = this.isConnectedRoof(this.f_58858_, direction.m_122428_(), false) == EnumSubType.EnumStyle.MIDDLE;
                    if (conL && conR) {
                        this.edgeType = "cap";
                        direction = Direction.NORTH;
                        break;
                    }
                    if (!conL && !conR) break;
                    this.edgeType = "end";
                    direction = conL ? direction.m_122424_() : direction;
                    break;
                }
                case 2: {
                    if (north && south || east & west) {
                        this.edgeType = "middle";
                        direction = north ? Direction.EAST : Direction.NORTH;
                        break;
                    }
                    this.edgeType = "l";
                    direction = north && east ? Direction.NORTH : (east ? Direction.EAST : (south ? Direction.SOUTH : Direction.WEST));
                    break;
                }
                case 3: {
                    this.edgeType = "t";
                    direction = !south ? Direction.NORTH : (!west ? Direction.EAST : (!north ? Direction.SOUTH : Direction.WEST));
                    break;
                }
                case 4: {
                    this.edgeType = "x";
                    direction = Direction.NORTH;
                }
            }
            return direction;
        }
        this.edgeType = this.isConnectedRoof(this.f_58858_.m_7494_(), facing, false, true) != style ? "upper" : "";
        EnumSubType.EnumStyle downStyle = this.isConnectedRoof(this.f_58858_.m_7495_(), facing.m_122424_(), true, true);
        this.edgeType = this.edgeType + (downStyle == style || downStyle == null ? "" : "lower");
        return null;
    }

    private boolean isRoofEdge(Direction direction) {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_121945_(direction));
        if (state.m_60734_() instanceof BlockPlatformRoof) {
            return BlockPlatformBase.getPlatformSubType(state).getStyleType() == EnumSubType.EnumStyle.EDGE;
        }
        return false;
    }

    private EnumSubType.EnumStyle isConnectedRoof(BlockPos pos, Direction direction, boolean opposite) {
        return this.isConnectedRoof(pos, direction, opposite, false);
    }

    private EnumSubType.EnumStyle isConnectedRoof(BlockPos pos, Direction direction, boolean opposite, boolean raw) {
        BlockState state = this.f_58857_.m_8055_(pos.m_121945_(direction));
        if (state.m_60734_() instanceof BlockPlatformRoof) {
            Direction facing = (Direction)state.m_61143_((Property)BlockPlatformRoof.FACING);
            EnumSubType.EnumStyle style = BlockPlatformBase.getPlatformSubType(state).getStyleType();
            if (opposite) {
                direction = direction.m_122424_();
            }
            switch (style) {
                case MIDDLE: 
                case RIGHT: 
                case LEFT: {
                    return facing == direction ? style : EnumSubType.EnumStyle.NONE;
                }
                case INSIDE: {
                    return opposite && (facing == direction || facing == direction.m_122428_()) ? (raw ? EnumSubType.EnumStyle.INSIDE : EnumSubType.EnumStyle.MIDDLE) : EnumSubType.EnumStyle.NONE;
                }
                case OUTSIDE: {
                    return !(opposite || facing != direction && facing != direction.m_122428_()) ? (raw ? EnumSubType.EnumStyle.OUTSIDE : EnumSubType.EnumStyle.MIDDLE) : EnumSubType.EnumStyle.NONE;
                }
            }
        }
        return raw ? null : EnumSubType.EnumStyle.NONE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox();
        aabb.m_82377_(0.0, 0.25, 0.0);
        return aabb;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        BlockEntity tile;
        if (this.hasRail() && this.f_58857_ != null && side != null && side.m_122434_() == Direction.Axis.Y && (tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side.m_122424_()))) != null) {
            return tile.getCapability(capability, side);
        }
        return super.getCapability(capability, side);
    }
}

