/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import net.minecraft.util.StringRepresentable;

public enum EnumCovering implements StringRepresentable
{
    NONE("0", 0, true),
    A1("1", 1, true),
    A2("2", 2, true),
    A3("3", 3, true),
    F1("f1", 1, false),
    F2("f2", 2, false),
    F3("f3", 3, false),
    S2("s2", 2, false);

    private final String name;
    private final boolean reactive;
    private final byte layer;

    private EnumCovering(String name, int layer, boolean reactive) {
        this.name = name;
        this.reactive = reactive;
        this.layer = (byte)layer;
    }

    public String m_7912_() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isWorldReactive() {
        return this.reactive;
    }

    public byte getLayer() {
        return this.layer;
    }

    public EnumCovering increment() {
        return switch (this) {
            case NONE -> A1;
            case A1 -> A2;
            case A2 -> A3;
            case F1 -> F2;
            case F2 -> F3;
            default -> this;
        };
    }

    public EnumCovering decrement() {
        return switch (this) {
            case A3 -> A2;
            case A2 -> A1;
            case F3 -> F2;
            case F2 -> F1;
            default -> NONE;
        };
    }

    public EnumCovering min() {
        return switch (this) {
            case A1, A2, A3 -> A1;
            case F1, F2, F3 -> F1;
            default -> this;
        };
    }

    public boolean canIncrement() {
        return this != this.increment();
    }

    public boolean canDecrement() {
        return this != this.decrement();
    }

    public boolean renderOnRails() {
        return this != S2;
    }

    public boolean renderSides() {
        return this != S2;
    }

    public static EnumCovering byName(String name) {
        for (EnumCovering entry : EnumCovering.values()) {
            if (!entry.m_7912_().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return NONE;
    }

    public static EnumCovering byIndex(int index) {
        EnumCovering[] values = EnumCovering.values();
        return index < 0 || index >= values.length ? NONE : values[index];
    }
}

