/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.selector.entity.PieceSelectorNearbySmeltables;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickSmeltBlock
extends PieceTrick {
    SpellParam<Vector3> position;

    public PieceTrickSmeltBlock(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(20.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(80.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 80);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Item item;
        Block block1;
        Vector3 positionVal = this.getParamValue(context, this.position);
        ItemStack tool = context.tool;
        if (tool.m_41619_()) {
            tool = PsiAPI.getPlayerCAD(context.caster);
        }
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        if (!context.focalPoint.m_20193_().m_7966_(context.caster, pos)) {
            return null;
        }
        BlockState state = context.focalPoint.m_20193_().m_8055_(pos);
        Block block = state.m_60734_();
        ItemStack stack = new ItemStack((ItemLike)block);
        BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, context.focalPoint.m_9236_(), pos, tool);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return null;
        }
        ItemStack result = PieceSelectorNearbySmeltables.simulateSmelt(context.focalPoint.m_20193_(), stack);
        if (!result.m_41619_() && (block1 = Block.m_49814_((Item)(item = result.m_41720_()))) != Blocks.f_50016_) {
            context.focalPoint.m_20193_().m_46597_(pos, block1.m_49966_());
            context.focalPoint.m_20193_().m_46796_(2001, pos, Block.m_49956_((BlockState)block1.m_49966_()));
        }
        return null;
    }
}

