/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickMoveBlock
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> target;

    public PieceTrickMoveBlock(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(10.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(15.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam(this.target);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 10);
        meta.addStat(EnumSpellStat.COST, 15);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        ItemStack tool = context.getHarvestTool();
        Vector3 positionVal = this.getParamValue(context, this.position);
        Vector3 targetVal = this.getParamValue(context, this.target);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        Level world = context.focalPoint.m_20193_();
        BlockPos pos = positionVal.toBlockPos();
        if (context.positionBroken != null && context.positionBroken.m_82425_().equals((Object)pos)) {
            return null;
        }
        BlockState state = world.m_8055_(pos);
        if (world.m_7702_(pos) != null || state.m_60811_() != PushReaction.NORMAL || state.m_60800_((BlockGetter)world, pos) == -1.0f || !PieceTrickBreakBlock.canHarvestBlock(state, context.caster, world, pos, tool)) {
            return null;
        }
        BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, world, pos, tool);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return null;
        }
        if (!targetVal.isAxial() || targetVal.isZero()) {
            return null;
        }
        Vector3 axis = targetVal.normalize();
        int x = pos.m_123341_() + (int)axis.x;
        int y = pos.m_123342_() + (int)axis.y;
        int z = pos.m_123343_() + (int)axis.z;
        BlockPos pos1 = new BlockPos(x, y, z);
        BlockState state1 = world.m_8055_(pos1);
        if (!world.m_7966_(context.caster, pos) || !world.m_7966_(context.caster, pos1)) {
            return null;
        }
        if (state1.m_60795_() || state1.m_247087_()) {
            world.m_7731_(pos1, state, 3);
            world.m_7471_(pos, false);
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        return null;
    }
}

