/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickBlaze
extends PieceTrick {
    SpellParam<Vector3> position;

    public PieceTrickBlaze(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(20.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(40.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 40);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        pos = pos.m_7495_();
        BlockState state = context.focalPoint.m_20193_().m_8055_(pos);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)context.focalPoint.m_20193_().m_46472_(), (LevelAccessor)context.focalPoint.m_20193_(), (BlockPos)pos), context.focalPoint.m_20193_().m_8055_(pos.m_121945_(Direction.UP)), (Entity)context.caster);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (placeEvent.isCanceled()) {
            return null;
        }
        if (state.m_60795_() || state.m_247087_()) {
            context.focalPoint.m_20193_().m_46597_(pos, Blocks.f_50083_.m_49966_());
        } else {
            pos = pos.m_7494_();
            state = context.focalPoint.m_20193_().m_8055_(pos);
            if (state.m_60795_() || state.m_247087_()) {
                context.focalPoint.m_20193_().m_46597_(pos, Blocks.f_50083_.m_49966_());
            }
        }
        return null;
    }
}

