/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.constant;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.common.Psi;

public class PieceConstantNumber
extends SpellPiece {
    private static final String TAG_CONSTANT_VALUE = "constantValue";
    public String valueStr;

    public PieceConstantNumber(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        super.initParams();
        this.valueStr = "0";
    }

    @Override
    public void drawAdditional(PoseStack pPoseStack, MultiBufferSource buffers, int light) {
        if (this.valueStr == null || this.valueStr.isEmpty() || this.valueStr.length() > 5) {
            this.valueStr = "0";
        }
        Minecraft mc = Minecraft.m_91087_();
        int color = Psi.magical ? 0 : 0xFFFFFF;
        float efflen = mc.f_91062_.m_92895_(this.valueStr);
        float scale = 1.0f;
        while (efflen > 16.0f) {
            efflen = (float)mc.f_91062_.m_92895_(this.valueStr) / (scale += 1.0f);
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f);
        pPoseStack.m_252880_((9.0f - efflen / 2.0f) * scale, 4.0f * scale, 0.0f);
        mc.f_91062_.m_271703_(this.valueStr, 0.0f, 0.0f, color, false, pPoseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        pPoseStack.m_85849_();
    }

    @Override
    public boolean interceptKeystrokes() {
        return true;
    }

    @Override
    public boolean onCharTyped(char character, int keyCode, boolean doit) {
        Object newValueStr;
        if ("FDfd".indexOf(character) >= 0) {
            return false;
        }
        String oldStr = this.valueStr;
        Object newStr = this.valueStr;
        if ((((String)newStr).equals("0") || ((String)newStr).equals("-0")) && "+-.".indexOf(character) < 0) {
            newStr = ((String)newStr).replace("0", "");
        }
        if (character == '+') {
            newStr = ((String)newStr).replace("-", "");
        } else if (character == '-') {
            if (!((String)newStr).startsWith("-")) {
                newStr = "-" + (String)newStr;
            }
        } else {
            newStr = (String)newStr + character;
        }
        if (((String)newStr).isEmpty()) {
            newStr = "0";
        }
        if (((String)(newStr = ((String)newStr).trim())).length() > 5) {
            return false;
        }
        try {
            Double.parseDouble((String)newStr);
            newValueStr = newStr;
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (doit) {
            this.valueStr = newValueStr;
        }
        return !((String)newValueStr).equals(oldStr);
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, boolean doit) {
        String newValueStr;
        String oldStr = this.valueStr;
        String newStr = this.valueStr;
        if (keyCode == 259) {
            if (newStr.length() == 2 && newStr.startsWith("-")) {
                newStr = "-0";
            } else if (newStr.equals("-")) {
                newStr = "0";
            } else if (!newStr.isEmpty()) {
                newStr = newStr.substring(0, newStr.length() - 1);
            }
        }
        if (newStr.isEmpty()) {
            newStr = "0";
        }
        if ((newStr = newStr.trim()).length() > 5) {
            return false;
        }
        try {
            Double.parseDouble(newStr);
            newValueStr = newStr;
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (doit) {
            this.valueStr = newValueStr;
        }
        return !newValueStr.equals(oldStr);
    }

    @Override
    public EnumPieceType getPieceType() {
        return EnumPieceType.CONSTANT;
    }

    @Override
    public void writeToNBT(CompoundTag cmp) {
        super.writeToNBT(cmp);
        cmp.m_128359_(TAG_CONSTANT_VALUE, this.valueStr);
    }

    @Override
    public void readFromNBT(CompoundTag cmp) {
        super.readFromNBT(cmp);
        this.valueStr = cmp.m_128461_(TAG_CONSTANT_VALUE);
    }

    @Override
    public Class<?> getEvaluationType() {
        return Double.class;
    }

    @Override
    public Object evaluate() {
        if (this.valueStr == null || this.valueStr.isEmpty() || this.valueStr.length() > 5) {
            this.valueStr = "0";
        }
        try {
            return Double.parseDouble(this.valueStr);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public Object execute(SpellContext context) {
        return this.evaluate();
    }
}

