/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.component;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.common.Psi;

public abstract class ItemCADComponent
extends Item
implements ICADComponent {
    private final HashMap<EnumCADStat, Integer> stats = new HashMap();

    public ItemCADComponent(Item.Properties properties) {
        super(properties.m_41487_(1));
        this.registerStats();
    }

    public void registerStats() {
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            EnumCADComponent componentType = this.getComponentType(stack);
            MutableComponent componentName = Component.m_237115_((String)componentType.getName());
            tooltip.add((Component)Component.m_237110_((String)"psimisc.component_type", (Object[])new Object[]{componentName}));
            for (EnumCADStat stat : (EnumCADStat[])EnumCADStat.class.getEnumConstants()) {
                if (stat.getSourceType() != componentType) continue;
                int statVal = this.getCADStatValue(stack, stat);
                Object statValStr = statVal == -1 ? "\u221e" : "" + statVal;
                MutableComponent name = Component.m_237115_((String)stat.getName()).m_130940_(ChatFormatting.AQUA);
                tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)name).m_130946_(": " + (String)statValStr));
            }
        });
    }

    public void addStat(HashMap<EnumCADStat, Integer> stats) {
        stats.forEach(this::addStat);
    }

    public void addStat(EnumCADStat stat, int value) {
        this.stats.put(stat, value);
    }

    public static void addStatToStack(ItemStack stack, EnumCADStat stat, int value) {
        if (stack.m_41720_() instanceof ItemCADComponent) {
            ((ItemCADComponent)stack.m_41720_()).addStat(stat, value);
        } else {
            Psi.logger.error("Tried to add stats to non-component Item: " + String.valueOf(stack.m_41720_().m_41466_()));
        }
    }

    public static void addStatToStack(Item item, EnumCADStat stat, int value) {
        if (item instanceof ItemCADComponent) {
            ((ItemCADComponent)item).addStat(stat, value);
        } else {
            Psi.logger.error("Tried to add stats to non-component Item: " + String.valueOf(item.m_41466_()));
        }
    }

    @Override
    public int getCADStatValue(ItemStack stack, EnumCADStat stat) {
        if (this.stats.containsKey((Object)stat)) {
            return this.stats.get((Object)stat);
        }
        return 0;
    }
}

