/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.projectile;

import com.github.L_Ender.cataclysm.blocks.EMP_Block;
import com.github.L_Ender.cataclysm.client.particle.LightningParticle;
import com.github.L_Ender.cataclysm.client.tool.ControlledAnimation;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Harbinger_Entity;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.The_Prowler_Entity;
import com.github.L_Ender.cataclysm.init.ModBlocks;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class Death_Laser_Beam_Entity
extends Entity {
    public static final double RADIUS = 30.0;
    public LivingEntity caster;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public float renderYaw;
    public float renderPitch;
    public ControlledAnimation appear = new ControlledAnimation(3);
    public boolean on = true;
    public Direction blockSide = null;
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(Death_Laser_Beam_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(Death_Laser_Beam_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(Death_Laser_Beam_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CASTER = SynchedEntityData.m_135353_(Death_Laser_Beam_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HEAD = SynchedEntityData.m_135353_(Death_Laser_Beam_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FIRE = SynchedEntityData.m_135353_(Death_Laser_Beam_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(Death_Laser_Beam_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HPDAMAGE = SynchedEntityData.m_135353_(Death_Laser_Beam_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float prevYaw;
    public float prevPitch;
    @OnlyIn(value=Dist.CLIENT)
    private Vec3[] attractorPos;

    public Death_Laser_Beam_Entity(EntityType<? extends Death_Laser_Beam_Entity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
        if (world.f_46443_) {
            this.attractorPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    public Death_Laser_Beam_Entity(EntityType<? extends Death_Laser_Beam_Entity> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration, float damage, float Hpdamage) {
        this(type, world);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.m_6034_(x, y, z);
        this.setDamage(damage);
        this.setHpDamage(Hpdamage);
        this.calculateEndPos();
        if (!world.f_46443_) {
            this.setCasterID(caster.m_19879_());
        }
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.prevYaw = this.renderYaw;
        this.prevPitch = this.renderPitch;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.f_19797_ == 1 && this.m_9236_().f_46443_) {
            this.caster = (LivingEntity)this.m_9236_().m_6815_(this.getCasterID());
        }
        if (!this.m_9236_().f_46443_) {
            if (this.caster instanceof The_Harbinger_Entity) {
                this.updateWithHarbinger();
            }
            if (this.caster instanceof The_Prowler_Entity) {
                this.updateWithProwler();
            }
        }
        if (this.caster != null) {
            this.renderYaw = (float)(((double)this.caster.f_20885_ + 90.0) * Math.PI / 180.0);
            this.renderPitch = (float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0);
        }
        if (!this.on && this.appear.getTimer() == 0) {
            this.m_146870_();
        }
        if (this.on && this.f_19797_ > 20) {
            this.appear.increaseTimer();
        } else {
            this.appear.decreaseTimer();
        }
        if (this.caster != null && !this.caster.m_6084_()) {
            this.m_146870_();
        }
        if (this.f_19797_ > 20) {
            this.calculateEndPos();
            List<LivingEntity> hit = this.raytraceEntities((Level)this.m_9236_(), (Vec3)new Vec3((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ), (boolean)false, (boolean)true, (boolean)true).entities;
            if (this.blockSide != null) {
                this.spawnExplosionParticles(5);
                if (!this.m_9236_().f_46443_) {
                    BlockState block;
                    for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.collidePosX - 0.5)), (int)Mth.m_14107_((double)(this.collidePosY - 0.5)), (int)Mth.m_14107_((double)(this.collidePosZ - 0.5)), (int)Mth.m_14107_((double)(this.collidePosX + 0.5)), (int)Mth.m_14107_((double)(this.collidePosY + 0.5)), (int)Mth.m_14107_((double)(this.collidePosZ + 0.5)))) {
                        block = this.m_9236_().m_8055_(pos);
                        if (block.m_60795_() || !block.m_204336_(ModTag.CM_GLASS) || !ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) continue;
                        this.m_9236_().m_46961_(pos, true);
                    }
                    for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.collidePosX - 2.5)), (int)Mth.m_14107_((double)(this.collidePosY - 2.5)), (int)Mth.m_14107_((double)(this.collidePosZ - 2.5)), (int)Mth.m_14107_((double)(this.collidePosX + 2.5)), (int)Mth.m_14107_((double)(this.collidePosY + 2.5)), (int)Mth.m_14107_((double)(this.collidePosZ + 2.5)))) {
                        block = this.m_9236_().m_8055_(pos);
                        if (!block.m_60713_((Block)ModBlocks.EMP.get()) || ((Boolean)block.m_61143_((Property)EMP_Block.POWERED)).booleanValue() || !((Boolean)block.m_61143_((Property)EMP_Block.OVERLOAD)).booleanValue()) continue;
                        this.m_9236_().m_46597_(pos, (BlockState)block.m_61124_((Property)EMP_Block.OVERLOAD, (Comparable)Boolean.valueOf(false)));
                    }
                    if (this.getFire()) {
                        BlockPos blockpos1 = BlockPos.m_274561_((double)this.collidePosX, (double)this.collidePosY, (double)this.collidePosZ);
                        if (CMConfig.HarbingerLightFire) {
                            if (this.m_9236_().m_46859_(blockpos1)) {
                                this.m_9236_().m_46597_(blockpos1, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos1));
                            }
                        } else if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && this.m_9236_().m_46859_(blockpos1)) {
                            this.m_9236_().m_46597_(blockpos1, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos1));
                        }
                    }
                }
            }
            if (!this.m_9236_().f_46443_) {
                for (LivingEntity target : hit) {
                    if (this.caster == null || this.caster.m_7307_((Entity)target) || target == this.caster) continue;
                    boolean flag = target.m_6469_(CMDamageTypes.causeDeathLaserDamage(this, this.caster), (float)((double)this.getDamage() + Math.min((double)this.getDamage(), (double)(target.m_21233_() * this.getHpDamage()) * 0.01)));
                    if (!this.getFire() || !flag) continue;
                    target.m_20254_(5);
                }
            }
        }
        if (this.f_19797_ - 20 > this.getDuration()) {
            this.on = false;
        }
    }

    private void spawnExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 1.5f;
            float yaw = (float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI);
            float motionY = this.f_19796_.m_188501_() * 0.8f;
            float motionX = 1.5f * Mth.m_14089_((float)yaw);
            float motionZ = 1.5f * Mth.m_14031_((float)yaw);
            this.m_9236_().m_7106_((ParticleOptions)new LightningParticle.OrbData(255, 26, 0), this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DURATION, (Object)0);
        this.f_19804_.m_135372_(CASTER, (Object)-1);
        this.f_19804_.m_135372_(HEAD, (Object)0);
        this.f_19804_.m_135372_(FIRE, (Object)false);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HPDAMAGE, (Object)Float.valueOf(0.0f));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getHpDamage() {
        return ((Float)this.f_19804_.m_135370_(HPDAMAGE)).floatValue();
    }

    public void setHpDamage(float damage) {
        this.f_19804_.m_135381_(HPDAMAGE, (Object)Float.valueOf(damage));
    }

    public float getYaw() {
        return ((Float)this.f_19804_.m_135370_(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.f_19804_.m_135370_(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(pitch));
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(DURATION, (Object)duration);
    }

    public int getHead() {
        return (Integer)this.f_19804_.m_135370_(HEAD);
    }

    public void setHead(int head) {
        this.f_19804_.m_135381_(HEAD, (Object)head);
    }

    public int getCasterID() {
        return (Integer)this.f_19804_.m_135370_(CASTER);
    }

    public void setCasterID(int id) {
        this.f_19804_.m_135381_(CASTER, (Object)id);
    }

    public boolean getFire() {
        return (Boolean)this.f_19804_.m_135370_(FIRE);
    }

    public void setFire(boolean fire) {
        this.f_19804_.m_135381_(FIRE, (Object)fire);
    }

    protected void m_7378_(CompoundTag nbt) {
    }

    protected void m_7380_(CompoundTag nbt) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void calculateEndPos() {
        if (this.m_9236_().m_5776_()) {
            this.endPosX = this.m_20185_() + 30.0 * Math.cos(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosZ = this.m_20189_() + 30.0 * Math.sin(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosY = this.m_20186_() + 30.0 * Math.sin(this.renderPitch);
        } else {
            this.endPosX = this.m_20185_() + 30.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.m_20189_() + 30.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.m_20186_() + 30.0 * Math.sin(this.getPitch());
        }
    }

    public LaserbeamHitResult raytraceEntities(Level world, Vec3 from, Vec3 to, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        LaserbeamHitResult result = new LaserbeamHitResult();
        result.setBlockHit((HitResult)world.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.blockHit != null) {
            Vec3 hitVec = result.blockHit.m_82450_();
            this.collidePosX = hitVec.f_82479_;
            this.collidePosY = hitVec.f_82480_;
            this.collidePosZ = hitVec.f_82481_;
            this.blockSide = result.blockHit.m_82434_();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.m_45976_(LivingEntity.class, new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82377_(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.m_6143_() + 0.5f;
            AABB aabb = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.m_82371_(from, to);
            if (aabb.m_82390_(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public void m_7334_(Entity entityIn) {
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    private void updateWithHarbinger() {
        this.setYaw((float)((double)(this.caster.f_20885_ + 90.0f) * Math.PI / 180.0));
        this.setPitch((float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0));
        this.m_6034_(this.caster.m_20185_(), this.caster.m_20186_() + 2.7, this.caster.m_20189_());
    }

    private void updateWithProwler() {
        this.setYaw((float)((double)(this.caster.f_20885_ + 90.0f) * Math.PI / 180.0));
        this.setPitch((float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0));
        this.m_6034_(this.caster.m_20185_(), this.caster.m_20186_() + 1.8, this.caster.m_20189_());
    }

    public static class LaserbeamHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

