/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public record ShapedTemplate(int width, int height, NonNullList<Ingredient> ingredients) {
    public static ShapedTemplate of(ShapedRecipe recipe) {
        return new ShapedTemplate(recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_());
    }

    public static ShapedTemplate fromJson(JsonObject json) {
        HashMap<Character, Ingredient> key = new HashMap<Character, Ingredient>();
        for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            key.put(Character.valueOf(((String)entry.getKey()).charAt(0)), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        JsonArray patternList = GsonHelper.m_13933_((JsonObject)json, (String)"pattern");
        if (patternList.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternList.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = GsonHelper.m_13805_((JsonElement)patternList.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        int width = pattern[0].length();
        int height = pattern.length;
        NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
        HashSet missingKeys = new HashSet(key.keySet());
        int ingredientIdx = 0;
        for (String line : pattern) {
            for (int x = 0; x < line.length(); ++x) {
                Ingredient ing;
                char chr = line.charAt(x);
                Ingredient ingredient = ing = chr == ' ' ? Ingredient.f_43901_ : (Ingredient)key.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                ingredients.set(ingredientIdx++, (Object)ing);
                missingKeys.remove(Character.valueOf(chr));
            }
        }
        if (!missingKeys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + missingKeys);
        }
        return new ShapedTemplate(width, height, (NonNullList<Ingredient>)ingredients);
    }

    public static ShapedTemplate fromNetwork(FriendlyByteBuf buffer) {
        int width = buffer.m_130242_();
        int height = buffer.m_130242_();
        NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        return new ShapedTemplate(width, height, (NonNullList<Ingredient>)ingredients);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.width());
        buffer.m_130130_(this.height());
        for (Ingredient ingredient : this.ingredients) {
            ingredient.m_43923_(buffer);
        }
    }
}

