/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CableBlockEntity
extends BlockEntity {
    private boolean refreshPeripheral;
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral(PlatformHelper.get().createPeripheralAccess(this, x -> this.queueRefreshPeripheral()));
    @Nullable
    private Runnable modemChanged;
    private boolean refreshConnections = false;
    private final WiredModemElement cable = new CableElement();
    private final WiredNode node = this.cable.getNode();
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule(this.tickToken)), this.cable, this.peripheral, this){

        @Override
        public Vec3 getPosition() {
            Direction dir = CableBlockEntity.this.getModemDirection();
            return Vec3.m_82512_((Vec3i)(dir == null ? CableBlockEntity.this.m_58899_() : CableBlockEntity.this.m_58899_().m_121945_(dir)));
        }
    };
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess(this, x -> this.scheduleConnectionsChanged());

    public CableBlockEntity(BlockEntityType<? extends CableBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_7651_() {
        super.m_7651_();
        this.modem.removed();
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.node.remove();
        }
    }

    public void m_6339_() {
        super.m_6339_();
        this.refreshPeripheral = true;
        this.refreshConnections = true;
        TickScheduler.schedule(this.tickToken);
    }

    @Deprecated
    public void m_155250_(BlockState state) {
        Direction direction = this.getModemDirection();
        boolean hasCable = this.hasCable();
        super.m_155250_(state);
        if (this.modemChanged != null && (this.hasCable() != hasCable || this.getModemDirection() != direction)) {
            this.modemChanged.run();
        }
    }

    @Nullable
    private Direction getModemDirection() {
        return ((CableModemVariant)((Object)this.m_58900_().m_61143_(CableBlock.MODEM))).getFacing();
    }

    void neighborChanged(BlockPos neighbour) {
        Direction dir = this.getModemDirection();
        if (!this.m_58904_().f_46443_ && dir != null && this.m_58899_().m_121945_(dir).equals((Object)neighbour) && this.isPeripheralOn()) {
            this.queueRefreshPeripheral();
        }
    }

    void queueRefreshPeripheral() {
        this.refreshPeripheral = true;
        TickScheduler.schedule(this.tickToken);
    }

    InteractionResult use(Player player) {
        if (!this.canAttachPeripheral()) {
            return InteractionResult.FAIL;
        }
        if (this.m_58904_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        String oldName = this.peripheral.getConnectedName();
        if (this.isPeripheralOn()) {
            this.detachPeripheral();
        } else {
            this.attachPeripheral();
        }
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equals(newName, oldName)) {
            if (oldName != null) {
                player.m_5661_((Component)Component.m_237110_((String)"chat.computercraft.wired_modem.peripheral_disconnected", (Object[])new Object[]{ChatHelpers.copy(oldName)}), false);
            }
            if (newName != null) {
                player.m_5661_((Component)Component.m_237110_((String)"chat.computercraft.wired_modem.peripheral_connected", (Object[])new Object[]{ChatHelpers.copy(newName)}), false);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.peripheral.read(nbt, "");
    }

    public void m_183515_(CompoundTag nbt) {
        this.peripheral.write(nbt, "");
        super.m_183515_(nbt);
    }

    private void updateBlockState() {
        CableModemVariant newVariant;
        BlockState state = this.m_58900_();
        CableModemVariant oldVariant = (CableModemVariant)((Object)state.m_61143_(CableBlock.MODEM));
        if (oldVariant != (newVariant = CableModemVariant.from(oldVariant.getFacing(), this.modem.getModemState().isOpen(), this.peripheral.hasPeripheral()))) {
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)state.m_61124_(CableBlock.MODEM, (Comparable)((Object)newVariant)));
        }
    }

    void blockTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.refreshPeripheral) {
            this.refreshPeripheral = false;
            if (this.isPeripheralOn()) {
                this.attachPeripheral();
            }
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        if (this.refreshConnections) {
            this.connectionsChanged();
        }
    }

    void scheduleConnectionsChanged() {
        this.refreshConnections = true;
        TickScheduler.schedule(this.tickToken);
    }

    void connectionsChanged() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        this.refreshConnections = false;
        BlockState state = this.m_58900_();
        Level world = this.m_58904_();
        BlockPos current = this.m_58899_();
        for (Direction facing : DirectionUtil.FACINGS) {
            WiredElement element;
            BlockPos offset = current.m_121945_(facing);
            if (!world.m_46749_(offset) || (element = this.connectedElements.get(facing)) == null) continue;
            WiredNode node = element.getNode();
            if (CableBlock.canConnectIn(state, facing)) {
                this.node.connectTo(node);
                continue;
            }
            this.node.disconnectFrom(node);
        }
        if (!this.canAttachPeripheral()) {
            this.detachPeripheral();
        }
    }

    private void attachPeripheral() {
        Direction dir = Objects.requireNonNull(this.getModemDirection(), "Attaching without a modem");
        if (this.peripheral.attach(this.m_58904_(), this.m_58899_(), dir)) {
            this.updateConnectedPeripherals();
        }
        this.updateBlockState();
    }

    private void detachPeripheral() {
        if (this.peripheral.detach()) {
            this.updateConnectedPeripherals();
        }
        this.updateBlockState();
    }

    private void updateConnectedPeripherals() {
        this.node.updatePeripherals(this.peripheral.toMap());
    }

    @Nullable
    public WiredElement getWiredElement(@Nullable Direction direction) {
        return direction == null || CableBlock.canConnectIn(this.m_58900_(), direction) ? this.cable : null;
    }

    @Nullable
    public IPeripheral getPeripheral(@Nullable Direction direction) {
        return direction == null || this.getModemDirection() == direction ? this.modem : null;
    }

    private boolean isPeripheralOn() {
        return ((CableModemVariant)((Object)this.m_58900_().m_61143_(CableBlock.MODEM))).isPeripheralOn();
    }

    public void onModemChanged(Runnable callback) {
        this.modemChanged = callback;
    }

    boolean hasCable() {
        return (Boolean)this.m_58900_().m_61143_((Property)CableBlock.CABLE);
    }

    public boolean hasModem() {
        return this.m_58900_().m_61143_(CableBlock.MODEM) != CableModemVariant.None;
    }

    private boolean canAttachPeripheral() {
        return this.hasCable() && this.hasModem();
    }

    private final class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        @Override
        public Level getLevel() {
            return CableBlockEntity.this.m_58904_();
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)CableBlockEntity.this.m_58899_());
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            CableBlockEntity.this.modem.attachPeripheral(name, peripheral);
        }

        @Override
        protected void detachPeripheral(String name) {
            CableBlockEntity.this.modem.detachPeripheral(name);
        }
    }
}

