/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class UpgradeRecipeGenerator<T> {
    private static final ResourceLocation TURTLE_UPGRADE = new ResourceLocation("computercraft", "turtle_upgrade");
    private static final ResourceLocation POCKET_UPGRADE = new ResourceLocation("computercraft", "pocket_upgrade");
    private final Function<CraftingRecipe, T> wrap;
    private final Map<Item, List<UpgradeInfo>> upgradeItemLookup = new HashMap<Item, List<UpgradeInfo>>();
    private final List<UpgradeInfo> pocketUpgrades = new ArrayList<UpgradeInfo>();
    private final List<UpgradeInfo> turtleUpgrades = new ArrayList<UpgradeInfo>();
    private boolean initialised = false;

    public UpgradeRecipeGenerator(Function<CraftingRecipe, T> wrap) {
        this.wrap = wrap;
    }

    private void setupCache() {
        UpgradeInfo info;
        ItemStack stack;
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        for (ITurtleUpgrade iTurtleUpgrade : TurtleUpgrades.instance().getUpgrades()) {
            stack = iTurtleUpgrade.getCraftingItem();
            if (stack.m_41619_()) {
                return;
            }
            info = new UpgradeInfo(stack, iTurtleUpgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.m_41720_(), k -> new ArrayList(1)).add(info);
            this.turtleUpgrades.add(info);
        }
        for (IPocketUpgrade iPocketUpgrade : PocketUpgrades.instance().getUpgrades()) {
            stack = iPocketUpgrade.getCraftingItem();
            if (stack.m_41619_()) {
                return;
            }
            info = new UpgradeInfo(stack, iPocketUpgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.m_41720_(), k -> new ArrayList(1)).add(info);
            this.pocketUpgrades.add(info);
        }
    }

    public boolean isUpgrade(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        this.setupCache();
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.m_41720_());
        if (upgrades == null) {
            return false;
        }
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.m_41619_() || craftingStack.m_41720_() != stack.m_41720_() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            return true;
        }
        return false;
    }

    public List<T> findRecipesWithInput(ItemStack stack) {
        this.setupCache();
        Item item = stack.m_41720_();
        if (item instanceof TurtleItem) {
            TurtleItem item2 = (TurtleItem)item;
            UpgradeData<ITurtleUpgrade> left = item2.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = item2.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null && right != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.turtleUpgrades) {
                if (upgrade.turtle == null) {
                    throw new NullPointerException();
                }
                if (left == null) {
                    recipes.add(this.turtle(ingredient, upgrade.ingredient, UpgradeRecipeGenerator.turtleWith(stack, UpgradeData.ofDefault(upgrade.turtle), right)));
                }
                if (right != null) continue;
                recipes.add(this.turtle(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.turtleWith(stack, left, UpgradeData.ofDefault(upgrade.turtle))));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.m_41720_() instanceof PocketComputerItem) {
            IPocketUpgrade back = PocketComputerItem.getUpgrade(stack);
            if (back != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.pocketUpgrades) {
                if (upgrade.pocket == null) {
                    throw new NullPointerException();
                }
                recipes.add(this.pocket(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.pocketWith(stack, UpgradeData.ofDefault(upgrade.pocket))));
            }
            return Collections.unmodifiableList(recipes);
        }
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.m_41720_());
        if (upgrades == null) {
            return List.of();
        }
        List recipes = null;
        boolean multiple = false;
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.m_41619_() || craftingStack.m_41720_() != stack.m_41720_() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            if (recipes == null) {
                recipes = upgrade.getRecipes();
                continue;
            }
            if (!multiple) {
                multiple = true;
                recipes = new ArrayList(recipes);
            }
            recipes.addAll(upgrade.getRecipes());
        }
        return recipes == null ? List.of() : Collections.unmodifiableList(recipes);
    }

    public List<T> findRecipesWithOutput(ItemStack stack) {
        ArrayList<T> recipes;
        Item item = stack.m_41720_();
        if (item instanceof TurtleItem) {
            TurtleItem item2 = (TurtleItem)item;
            recipes = new ArrayList<T>(0);
            UpgradeData<ITurtleUpgrade> left = item2.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = item2.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null) {
                recipes.add(this.turtle(Ingredient.m_43927_((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.turtleWith(stack, null, right)}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{left.getUpgradeItem()}), stack));
            }
            if (right != null) {
                recipes.add(this.turtle(Ingredient.m_43927_((ItemStack[])new ItemStack[]{right.getUpgradeItem()}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.turtleWith(stack, left, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.m_41720_() instanceof PocketComputerItem) {
            recipes = new ArrayList(0);
            UpgradeData<IPocketUpgrade> back = PocketComputerItem.getUpgradeWithData(stack);
            if (back != null) {
                recipes.add(this.pocket(Ingredient.m_43927_((ItemStack[])new ItemStack[]{back.getUpgradeItem()}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.pocketWith(stack, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        return List.of();
    }

    private static ItemStack turtleWith(ItemStack stack, @Nullable UpgradeData<ITurtleUpgrade> left, @Nullable UpgradeData<ITurtleUpgrade> right) {
        TurtleItem item = (TurtleItem)stack.m_41720_();
        return item.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), left, right, item.getFuelLevel(stack), item.getOverlay(stack));
    }

    private static ItemStack pocketWith(ItemStack stack, @Nullable UpgradeData<IPocketUpgrade> back) {
        PocketComputerItem item = (PocketComputerItem)stack.m_41720_();
        return item.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), back);
    }

    private T pocket(Ingredient upgrade, Ingredient pocketComputer, ItemStack result) {
        return this.wrap.apply((CraftingRecipe)new ShapedRecipe(POCKET_UPGRADE, "", CraftingBookCategory.MISC, 1, 2, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{upgrade, pocketComputer}), result));
    }

    private T turtle(Ingredient left, Ingredient right, ItemStack result) {
        return this.wrap.apply((CraftingRecipe)new ShapedRecipe(TURTLE_UPGRADE, "", CraftingBookCategory.MISC, 2, 1, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{left, right}), result));
    }

    private class UpgradeInfo {
        final ItemStack stack;
        final Ingredient ingredient;
        @Nullable
        final ITurtleUpgrade turtle;
        @Nullable
        final IPocketUpgrade pocket;
        final UpgradeBase upgrade;
        @Nullable
        private ArrayList<T> recipes;

        UpgradeInfo(ItemStack stack, ITurtleUpgrade turtle) {
            this.stack = stack;
            this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            this.turtle = turtle;
            this.upgrade = this.turtle;
            this.pocket = null;
        }

        UpgradeInfo(ItemStack stack, IPocketUpgrade pocket) {
            this.stack = stack;
            this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            this.turtle = null;
            this.pocket = pocket;
            this.upgrade = this.pocket;
        }

        List<T> getRecipes() {
            ArrayList<Object> recipes = this.recipes;
            if (recipes != null) {
                return recipes;
            }
            this.recipes = new ArrayList(4);
            recipes = this.recipes;
            if (this.turtle != null) {
                for (Supplier<IColouredItem> supplier : RecipeModHelpers.TURTLES) {
                    TurtleItem turtleItem = (TurtleItem)supplier.get();
                    recipes.add(UpgradeRecipeGenerator.this.turtle(this.ingredient, Ingredient.m_43927_((ItemStack[])new ItemStack[]{turtleItem.create(-1, null, -1, null, null, 0, null)}), turtleItem.create(-1, null, -1, null, UpgradeData.ofDefault(this.turtle), 0, null)));
                }
            }
            if (this.pocket != null) {
                for (Supplier<IColouredItem> supplier : RecipeModHelpers.POCKET_COMPUTERS) {
                    PocketComputerItem pocketItem = (PocketComputerItem)supplier.get();
                    recipes.add(UpgradeRecipeGenerator.this.pocket(this.ingredient, Ingredient.m_43927_((ItemStack[])new ItemStack[]{pocketItem.create(-1, null, -1, null)}), pocketItem.create(-1, null, -1, UpgradeData.ofDefault(this.pocket))));
                }
            }
            recipes.trimToSize();
            return recipes;
        }
    }
}

