/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import javax.annotation.Nullable;

public final class MachineResult {
    public static final MachineResult OK = new MachineResult(false, false, null);
    public static final MachineResult PAUSE = new MachineResult(false, true, null);
    public static final MachineResult TIMEOUT = new MachineResult(true, false, "Too long without yielding");
    public static final MachineResult GENERIC_ERROR = new MachineResult(true, false, null);
    private final boolean error;
    private final boolean pause;
    @Nullable
    private final String message;

    private MachineResult(boolean error, boolean pause, @Nullable String message) {
        this.pause = pause;
        this.message = message;
        this.error = error;
    }

    public static MachineResult error(String error) {
        return new MachineResult(true, false, error);
    }

    public static MachineResult error(Exception error) {
        return new MachineResult(true, false, error.getMessage());
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isPause() {
        return this.pause;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }
}

