/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Set;

record FileFlags(boolean read, boolean write, boolean truncate, boolean create, boolean append) {
    public static FileFlags of(Set<OpenOption> options) throws IOException {
        boolean read = false;
        boolean write = false;
        boolean truncate = false;
        boolean create = false;
        boolean append = false;
        for (OpenOption option : options) {
            if (!(option instanceof StandardOpenOption)) {
                throw new IOException("Unsupported mode");
            }
            StandardOpenOption stdOption = (StandardOpenOption)option;
            switch (stdOption) {
                case READ: {
                    read = true;
                    break;
                }
                case WRITE: {
                    write = true;
                    break;
                }
                case APPEND: {
                    append = true;
                    write = true;
                    break;
                }
                case TRUNCATE_EXISTING: {
                    truncate = true;
                    break;
                }
                case CREATE: {
                    create = true;
                    break;
                }
                case CREATE_NEW: 
                case DELETE_ON_CLOSE: 
                case SPARSE: 
                case SYNC: 
                case DSYNC: {
                    throw new IOException("Unsupported mode");
                }
            }
        }
        if (!read && !write) {
            read = true;
        }
        if (read && append) {
            throw new IllegalArgumentException("Cannot use READ and APPEND");
        }
        if (append && truncate) {
            throw new IllegalArgumentException("Cannot use APPEND and TRUNCATE_EXISTING");
        }
        return new FileFlags(read, write, truncate, create, append);
    }
}

