/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.command.text.TableFormatter;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class ClientTableFormatter
implements TableFormatter {
    public static final ClientTableFormatter INSTANCE = new ClientTableFormatter();

    private static Font renderer() {
        return Minecraft.m_91087_().f_91062_;
    }

    @Override
    @Nullable
    public Component getPadding(Component component, int width) {
        int extraWidth = width - this.getWidth(component);
        if (extraWidth <= 0) {
            return null;
        }
        Font renderer = ClientTableFormatter.renderer();
        float spaceWidth = renderer.m_92895_(" ");
        int spaces = Mth.m_14143_((float)((float)extraWidth / spaceWidth));
        int extra = extraWidth - (int)((float)spaces * spaceWidth);
        return ChatHelpers.coloured(StringUtils.repeat((char)' ', (int)spaces) + StringUtils.repeat((char)'\u02c8', (int)extra), ChatFormatting.GRAY);
    }

    @Override
    public int getColumnPadding() {
        return 3;
    }

    @Override
    public int getWidth(Component component) {
        return ClientTableFormatter.renderer().m_92852_((FormattedText)component);
    }

    @Override
    public void writeLine(String label, Component component) {
        Minecraft mc = Minecraft.m_91087_();
        ChatComponent chat = mc.f_91065_.m_93076_();
        chat.m_240964_(component, null, ClientTableFormatter.createTag(label));
    }

    @Override
    public void display(TableBuilder table) {
        ChatComponent chat = Minecraft.m_91087_().f_91065_.m_93076_();
        GuiMessageTag tag = ClientTableFormatter.createTag(table.getId());
        if (chat.f_93760_.removeIf(guiMessage -> guiMessage.f_240352_() != null && Objects.equals(guiMessage.f_240352_().f_240342_(), tag.f_240342_()))) {
            chat.m_241120_();
        }
        TableFormatter.super.display(table);
    }

    private static GuiMessageTag createTag(String id) {
        return new GuiMessageTag(0xA0A0A0, null, null, "ComputerCraft/" + id);
    }
}

