/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.blueflame.network;

import cy.jdkdigital.blueflame.BlueFlame;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class FirePacket {
    private final CompoundTag nbt;
    private final int entityID;

    public FirePacket(int entityID, CompoundTag nbt) {
        this.nbt = nbt;
        this.entityID = entityID;
    }

    public static void encode(FirePacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityID);
        buf.m_130079_(msg.nbt);
    }

    public static FirePacket decode(FriendlyByteBuf buf) {
        return new FirePacket(buf.readInt(), buf.m_130260_());
    }

    public static class Handler {
        public static void handle(FirePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity;
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world != null && (entity = world.m_6815_(message.entityID)) != null) {
                    entity.getCapability(BlueFlame.BLUE_FLAME_CAPABILITY).ifPresent(iBlueFlameProvider -> iBlueFlameProvider.deserializeNBT((Tag)message.nbt));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

