/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class PotionGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "potion";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, slot) -> stack.m_41720_() instanceof PotionItem);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41613_() > 0 && this.getSlotInputPredicates().get(0).test(((SidedInventoryComponent)inputs[0]).getStackInSlot(0), 0);
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41613_() > 0) {
            ItemStack calculate = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41777_();
            ItemStack stack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0);
            if (stack.m_41613_() == 1) {
                ((SidedInventoryComponent)inputs[0]).setStackInSlot(0, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                stack.m_41774_(1);
            }
            return this.calculate(calculate);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.PURPLE};
    }

    @Override
    public Item getDisplay() {
        return Items.f_42589_;
    }

    @Override
    public int getSlotSize() {
        return 1;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes() {
        return ForgeRegistries.POTIONS.getValues().stream().filter(potion -> potion != Potions.f_43598_).map(effect -> Arrays.asList(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)effect), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)effect), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)effect))).flatMap(Collection::stream).map(stack -> new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}))), new ArrayList<List<FluidStack>>(), (Integer)this.calculate((ItemStack)stack).getLeft(), (Integer)this.calculate((ItemStack)stack).getRight())).collect(Collectors.toList());
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        int duration = 80;
        int amplifier = 1;
        for (MobEffectInstance potionEffect : potion.m_43488_()) {
            duration += potionEffect.m_19557_();
            amplifier += potionEffect.m_19564_();
        }
        double powValue = 2.0;
        if (stack.m_41720_() instanceof ThrowablePotionItem) {
            powValue = 2.5;
        }
        if (stack.m_41720_() instanceof LingeringPotionItem) {
            powValue = 3.0;
        }
        return Pair.of((Object)duration, (Object)((int)(Math.pow(amplifier, powValue) * 10.0)));
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42588_).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50255_).m_206416_(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }
}

