/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.core;

import appeng.api.orientation.BlockOrientation;
import appeng.api.upgrades.Upgrades;
import appeng.block.networking.EnergyCellBlockItem;
import appeng.client.gui.implementations.InterfaceScreen;
import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.init.client.InitScreens;
import appeng.items.tools.powered.AbstractPortableCell;
import gripe._90.megacells.client.gui.CellDockScreen;
import gripe._90.megacells.core.Addons;
import gripe._90.megacells.core.Loaders;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAMenus;
import gripe._90.megacells.integration.ae2wt.AE2WTIntegration;
import gripe._90.megacells.integration.appbot.AppBotIntegration;
import gripe._90.megacells.integration.appbot.AppBotItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public interface Platform {
    public Loaders getLoader();

    public CreativeModeTab.Builder getCreativeTabBuilder();

    public boolean isAddonLoaded(Addons var1);

    default public void initItems() {
        MEGAItems.init();
        MEGABlocks.init();
        MEGABlockEntities.init();
        if (this.isAddonLoaded(Addons.APPBOT)) {
            AppBotItems.init();
        }
    }

    default public List<ItemLike> getAllCells() {
        ArrayList cells = new ArrayList(MEGAItems.getItemCells());
        cells.addAll(MEGAItems.getFluidCells());
        cells.add(MEGAItems.BULK_ITEM_CELL);
        if (this.isAddonLoaded(Addons.APPBOT)) {
            cells.addAll(AppBotItems.getCells());
        }
        return cells;
    }

    default public List<ItemLike> getAllPortables() {
        ArrayList<ItemDefinition<? extends AbstractPortableCell>> portables = new ArrayList<ItemDefinition<? extends AbstractPortableCell>>(MEGAItems.getItemPortables());
        portables.addAll(MEGAItems.getFluidPortables());
        if (this.isAddonLoaded(Addons.APPBOT)) {
            portables.addAll(AppBotItems.getPortables());
        }
        return portables;
    }

    public void register();

    default public void initUpgrades() {
        String storageCellGroup = GuiText.StorageCells.getTranslationKey();
        String portableCellGroup = GuiText.PortableCells.getTranslationKey();
        String interfaceGroup = GuiText.Interface.getTranslationKey();
        String wirelessTerminalGroup = GuiText.WirelessTerminals.getTranslationKey();
        for (ItemDefinition<?> itemDefinition : MEGAItems.getItemCells()) {
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.VOID_CARD, itemDefinition, (int)1, (String)storageCellGroup);
        }
        for (ItemDefinition<?> itemDefinition : MEGAItems.getFluidCells()) {
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.VOID_CARD, itemDefinition, (int)1, (String)storageCellGroup);
        }
        for (ItemDefinition itemDefinition : MEGAItems.getItemPortables()) {
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)itemDefinition, (int)1, (String)portableCellGroup);
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, (ItemLike)itemDefinition, (int)1, (String)portableCellGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)itemDefinition, (int)2, (String)portableCellGroup);
            Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, (ItemLike)itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)itemDefinition, (int)1, (String)storageCellGroup);
        }
        for (ItemDefinition itemDefinition : MEGAItems.getFluidPortables()) {
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, (ItemLike)itemDefinition, (int)1, (String)portableCellGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)itemDefinition, (int)2, (String)portableCellGroup);
            Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, (ItemLike)itemDefinition, (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)itemDefinition, (int)1, (String)storageCellGroup);
        }
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
        Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.WIRELESS_TERMINAL, (int)2, (String)wirelessTerminalGroup);
        Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.WIRELESS_CRAFTING_TERMINAL, (int)2, (String)wirelessTerminalGroup);
        Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.COLOR_APPLICATOR, (int)2);
        Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.MATTER_CANNON, (int)2);
        Upgrades.add(MEGAItems.COMPRESSION_CARD, MEGAItems.BULK_ITEM_CELL, (int)1);
        for (ItemDefinition itemDefinition : List.of(AEItems.PORTABLE_ITEM_CELL1K, AEItems.PORTABLE_ITEM_CELL4K, AEItems.PORTABLE_ITEM_CELL16K, AEItems.PORTABLE_ITEM_CELL64K, AEItems.PORTABLE_ITEM_CELL256K, AEItems.PORTABLE_FLUID_CELL1K, AEItems.PORTABLE_FLUID_CELL4K, AEItems.PORTABLE_FLUID_CELL16K, AEItems.PORTABLE_FLUID_CELL64K, AEItems.PORTABLE_FLUID_CELL256K)) {
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)itemDefinition, (int)2, (String)portableCellGroup);
        }
        if (this.isAddonLoaded(Addons.AE2WTLIB)) {
            AE2WTIntegration.initUpgrades();
        }
        if (this.isAddonLoaded(Addons.APPBOT)) {
            AppBotIntegration.initUpgrades();
        }
    }

    public void initCompression();

    public void initLavaTransform();

    public void addVillagerTrade(ItemLike var1, int var2, int var3, int var4);

    public void addIntegrationRecipe(Consumer<FinishedRecipe> var1, FinishedRecipe var2, Addons var3, ResourceLocation var4);

    public void addIntegrationRecipe(Consumer<FinishedRecipe> var1, RecipeBuilder var2, Addons var3, ResourceLocation var4);

    public static interface Client {
        public void initScreens();

        public void initEnergyCellProps();

        public void initCraftingUnitModels();

        public void initItemColours(ItemColor var1, List<ItemLike> var2);

        default public Runnable energyCellProps() {
            return () -> ItemProperties.m_174570_((Item)MEGABlocks.MEGA_ENERGY_CELL.m_5456_(), (ResourceLocation)AppEng.makeId((String)"fill_level"), (is, level, entity, i) -> {
                EnergyCellBlockItem energyCell = (EnergyCellBlockItem)MEGABlocks.MEGA_ENERGY_CELL.m_5456_();
                double curPower = energyCell.getAECurrentPower(is);
                double maxPower = energyCell.getAEMaxPower(is);
                return (float)(curPower / maxPower);
            });
        }

        default public void screens() {
            InitScreens.register(MEGAMenus.MEGA_INTERFACE, InterfaceScreen::new, (String)"/screens/megacells/mega_interface.json");
            InitScreens.register(MEGAMenus.MEGA_PATTERN_PROVIDER, PatternProviderScreen::new, (String)"/screens/megacells/mega_pattern_provider.json");
            InitScreens.register(MEGAMenus.CELL_DOCK, CellDockScreen::new, (String)"/screens/megacells/cell_dock.json");
        }

        public BakedModel createCellModel(Item var1, BlockOrientation var2);
    }
}

