/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.field.UnsyncedField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableIngredientSerializer;
import slimeknights.mantle.util.typed.TypedMap;

public class PotionIngredient
extends AbstractIngredient {
    public static final LoadableIngredientSerializer<PotionIngredient> SERIALIZER = new LoadableIngredientSerializer<PotionIngredient>(RecordLoadable.create(ItemsField.INSTANCE, new UnsyncedField<TagKey, PotionIngredient>(Loadables.ITEM_TAG.nullableField("tag", i -> i.itemTag)), Loadables.POTION.requiredField("potion", i -> i.potion), PotionIngredient::new));
    private final List<Item> items;
    @Nullable
    private final TagKey<Item> itemTag;
    private final Potion potion;

    protected PotionIngredient(List<Item> items, @Nullable TagKey<Item> itemTag, Potion potion) {
        super(Stream.concat(items.stream().map(item -> new Ingredient.ItemValue(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)potion))), Stream.ofNullable(itemTag).map(tag -> new PotionTagValue((TagKey<Item>)tag, potion))));
        this.items = items;
        this.itemTag = null;
        this.potion = potion;
    }

    public static PotionIngredient of(Potion potion, List<Item> items) {
        return new PotionIngredient(items, null, potion);
    }

    public static PotionIngredient of(Potion potion, Item ... items) {
        return PotionIngredient.of(potion, Arrays.asList(items));
    }

    public static PotionIngredient of(Potion potion, TagKey<Item> tag) {
        return new PotionIngredient(List.of(), tag, potion);
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && super.test(stack) && PotionUtils.m_43579_((ItemStack)stack) == this.potion;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement m_43942_() {
        return SERIALIZER.serialize(this);
    }

    private static class PotionTagValue
    extends Ingredient.TagValue {
        private final Potion potion;

        public PotionTagValue(TagKey<Item> tag, Potion potion) {
            super(tag);
            this.potion = potion;
        }

        public Collection<ItemStack> m_6223_() {
            return super.m_6223_().stream().map(item -> PotionUtils.m_43549_((ItemStack)item, (Potion)this.potion)).toList();
        }
    }

    private static enum ItemsField implements RecordField<List<Item>, PotionIngredient>
    {
        INSTANCE;

        private static final Loadable<List<Item>> ITEM_LIST;

        @Override
        public List<Item> get(JsonObject json, TypedMap context) {
            return ITEM_LIST.getOrDefault(json, "item", List.of(), context);
        }

        @Override
        public void serialize(PotionIngredient parent, JsonObject json) {
            if (parent.items.isEmpty()) {
                json.add("item", ITEM_LIST.serialize(parent.items));
            }
        }

        @Override
        public List<Item> decode(FriendlyByteBuf buffer, TypedMap context) {
            return (List)ITEM_LIST.decode(buffer, context);
        }

        @Override
        public void encode(FriendlyByteBuf buffer, PotionIngredient parent) {
            ITEM_LIST.encode(buffer, Arrays.stream(parent.m_43908_()).map(ItemStack::m_41720_).toList());
        }

        static {
            ITEM_LIST = Loadables.ITEM.list(-2);
        }
    }
}

