/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.block;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.registry.ModStats;

public class WoodcutterBlock
extends HorizontalDirectionalBlock
implements BucketPickup,
LiquidBlockContainer {
    public static final Component TRANSLATION = Component.m_237115_((String)"container.corail_woodcutter.woodcutter");
    private static final EnumMap<Direction, VoxelShape> SHAPE_BY_DIRECTION = new EnumMap(Direction.class);
    protected static final double[][] BOUNDS = new double[][]{{0.0, 0.5, 0.1875, 1.0, 0.5625, 0.8125}, {0.125, 0.0, 0.3125, 0.1875, 0.5, 0.375}, {0.125, 0.0, 0.625, 0.1875, 0.5, 0.6875}, {0.8125, 0.0, 0.625, 0.875, 0.5, 0.6875}, {0.8125, 0.0, 0.3125, 0.875, 0.5, 0.375}, {0.1875, 0.3125, 0.625, 0.8125, 0.375, 0.6875}, {0.1875, 0.3125, 0.3125, 0.8125, 0.375, 0.375}};

    public WoodcutterBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60999_().m_60978_(3.5f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60734_() != this && state.m_60819_().m_76152_() == Fluids.f_76193_));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            player.m_5893_(state.m_60750_(worldIn, pos));
            player.m_36220_(ModStats.INTERACT_WITH_SAWMILL);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        return new SimpleMenuProvider((id, playerInventory, player) -> new WoodcutterContainer(id, playerInventory, ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos)), TRANSLATION);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_DIRECTION.computeIfAbsent((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), direction -> Arrays.stream(BOUNDS).map(b -> this.createShapeForDirection((double[])b, (Direction)direction)).reduce(Shapes.m_83040_(), Shapes::m_83110_));
    }

    private VoxelShape createShapeForDirection(double[] bounds, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> Shapes.m_83048_((double)bounds[0], (double)bounds[1], (double)(1.0 - bounds[5]), (double)bounds[3], (double)bounds[4], (double)(1.0 - bounds[2]));
            case Direction.WEST -> Shapes.m_83048_((double)bounds[2], (double)bounds[1], (double)bounds[0], (double)bounds[5], (double)bounds[4], (double)bounds[3]);
            case Direction.EAST -> Shapes.m_83048_((double)(1.0 - bounds[5]), (double)bounds[1], (double)bounds[0], (double)(1.0 - bounds[2]), (double)bounds[4], (double)bounds[3]);
            default -> Shapes.m_83048_((double)bounds[0], (double)bounds[1], (double)bounds[2], (double)bounds[3], (double)bounds[4], (double)bounds[5]);
        };
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        return null;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        drops.add(new ItemStack((ItemLike)this));
        return drops;
    }

    public BlockState m_7417_(BlockState olState, Direction facing, BlockState newState, LevelAccessor levelAccessor, BlockPos oldPos, BlockPos newPos) {
        if (((Boolean)olState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            levelAccessor.m_186469_(oldPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(olState, facing, newState, levelAccessor, oldPos, newPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            levelAccessor.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            if (!levelAccessor.m_5776_()) {
                levelAccessor.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 3);
                levelAccessor.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)levelAccessor));
            }
            return true;
        }
        return false;
    }

    public boolean m_7420_(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }
}

