/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block.tile;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.CamouflageableBlock;
import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.util.Scheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;

public class TemplateFrameBlockEntity
extends BlockEntity
implements ICamouflageable {
    private static final String NBT_CAMO_NAME = "CamouflageName";
    private static final String NBT_MIMIC = "Mimic";
    private BlockState camouflage = null;
    private boolean extendedMimic;

    public TemplateFrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TEMPLATE_FRAME.get(), pos, state);
    }

    @Override
    public BlockState getCamouflage() {
        return this.camouflage;
    }

    public void setCamouflage(BlockState camouflage) {
        this.camouflage = camouflage;
        this.requestModelDataUpdate();
        this.m_6596_();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(CamouflageableBlock.CAMOUFLAGE_STATE, (Object)this.camouflage).build();
    }

    @Override
    public boolean extendedMimic() {
        return this.extendedMimic;
    }

    public void setExtendedMimic(boolean mimic) {
        this.extendedMimic = mimic;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.camouflage = this.getCamoStateFromNBT(compound);
        this.extendedMimic = compound.m_128471_(NBT_MIMIC);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_(NBT_MIMIC, this.extendedMimic);
        if (this.camouflage != null) {
            compound.m_128365_(NBT_CAMO_NAME, (Tag)NbtUtils.m_129202_((BlockState)this.camouflage));
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.camouflage = this.getCamoStateFromNBT(pkt.m_131708_());
            this.extendedMimic = pkt.m_131708_().m_128471_(NBT_MIMIC);
            if (this.camouflage != null && this.extendedMimic && this.camouflage.getLightEmission((BlockGetter)this.m_58904_(), this.m_58899_()) > 0) {
                Objects.requireNonNull(this.m_58904_()).m_7726_().m_7827_().m_7174_(this.f_58858_);
            }
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.camouflage = this.getCamoStateFromNBT(tag);
        this.extendedMimic = tag.m_128471_(NBT_MIMIC);
        if (this.camouflage != null && this.extendedMimic && this.camouflage.getLightEmission((BlockGetter)this.m_58904_(), this.m_58899_()) > 0) {
            Scheduler.client().schedule(() -> Objects.requireNonNull(this.m_58904_()).m_7726_().m_7827_().m_7174_(this.f_58858_), 1L);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("x", this.f_58858_.m_123341_());
        compound.m_128405_("y", this.f_58858_.m_123342_());
        compound.m_128405_("z", this.f_58858_.m_123343_());
        compound.m_128379_(NBT_MIMIC, this.extendedMimic);
        return TemplateFrameBlockEntity.getNBTFromCamoState(compound, this.camouflage);
    }

    private BlockState getCamoStateFromNBT(CompoundTag tag) {
        if (tag.m_128441_(NBT_CAMO_NAME)) {
            return NbtUtils.m_247651_((HolderGetter)this.f_58857_.m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_(NBT_CAMO_NAME));
        }
        return null;
    }

    private static CompoundTag getNBTFromCamoState(CompoundTag compound, BlockState camouflage) {
        if (camouflage != null) {
            compound.m_128365_(NBT_CAMO_NAME, (Tag)NbtUtils.m_129202_((BlockState)camouflage));
        }
        return compound;
    }

    public void setCamouflage(ItemStack itemStack, Direction facing, Direction routerFacing) {
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem b = (BlockItem)item;
            this.camouflage = b.m_40614_().m_49966_();
            if (this.camouflage.m_61138_((Property)BlockStateProperties.f_61365_)) {
                this.camouflage = (BlockState)this.camouflage.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)facing.m_122434_());
            } else if (this.camouflage.m_61138_((Property)BlockStateProperties.f_61372_)) {
                this.camouflage = (BlockState)this.camouflage.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
            } else if (this.camouflage.m_61138_((Property)BlockStateProperties.f_61374_)) {
                this.camouflage = (BlockState)this.camouflage.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)(facing.m_122434_() == Direction.Axis.Y ? routerFacing : facing));
            }
            this.m_6596_();
        }
    }
}

