/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.tables.client.inventory.module.SideInventoryScreen;
import slimeknights.tconstruct.tables.client.inventory.widget.TinkerTabsWidget;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.menu.module.SideInventoryContainer;

public class BaseTabbedScreen<TILE extends BlockEntity, CONTAINER extends TabbedContainerMenu<TILE>>
extends MultiModuleScreen<CONTAINER> {
    protected static final Component COMPONENT_WARNING = TConstruct.makeTranslation("gui", "warning");
    protected static final Component COMPONENT_ERROR = TConstruct.makeTranslation("gui", "error");
    public static final ResourceLocation BLANK_BACK = TConstruct.getResource("textures/gui/blank.png");
    @Nullable
    protected final TILE tile;
    protected TinkerTabsWidget tabsScreen;

    public BaseTabbedScreen(CONTAINER container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tile = container.getTile();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tabsScreen = (TinkerTabsWidget)this.m_142416_(new TinkerTabsWidget(this));
    }

    @Nullable
    public TILE getTileEntity() {
        return this.tile;
    }

    protected void drawIcon(GuiGraphics graphics, Slot slot, ElementScreen element) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Icons.ICONS);
        element.draw(graphics, slot.f_40220_ + this.cornerX - 1, slot.f_40221_ + this.cornerY - 1);
    }

    protected void drawIconEmpty(GuiGraphics graphics, Slot slot, ElementScreen element) {
        if (slot.m_6657_()) {
            return;
        }
        this.drawIcon(graphics, slot, element);
    }

    protected void drawIconEmpty(GuiGraphics graphics, Slot slot, Pattern pattern) {
        if (!slot.m_6657_()) {
            GuiUtil.renderPattern(graphics, pattern, slot.f_40220_ + this.cornerX, slot.f_40221_ + this.cornerY);
        }
    }

    public void error(Component message) {
    }

    public void warning(Component message) {
    }

    public void updateDisplay() {
    }

    protected boolean addChestSideInventory(Inventory inventory) {
        SideInventoryContainer sideInventoryContainer = (SideInventoryContainer)((TabbedContainerMenu)this.getMenu()).getSubContainer(SideInventoryContainer.class);
        if (sideInventoryContainer != null) {
            MutableComponent sideInventoryName = Component.m_237119_();
            BlockEntity te = sideInventoryContainer.getTile();
            if (te instanceof MenuProvider) {
                sideInventoryName = (Component)Objects.requireNonNullElse(((MenuProvider)te).m_5446_(), Component.m_237119_());
            }
            this.addModule(new SideInventoryScreen<BaseTabbedScreen, SideInventoryContainer>(this, sideInventoryContainer, inventory, (Component)sideInventoryName, sideInventoryContainer.getSlotCount(), sideInventoryContainer.getColumns()));
            return true;
        }
        return false;
    }

    public List<Rect2i> getModuleAreas() {
        List areas = super.getModuleAreas();
        if (this.tabsScreen != null) {
            areas.add(this.tabsScreen.getArea());
        } else {
            TConstruct.LOG.error("Someone is trying to access module areas before the screen is initialized. This usually indicates a recipe viewer badly implementing the JEI API. Report this issue to your recipe viewer.");
        }
        return areas;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !this.tabsScreen.m_5953_(mouseX, mouseY);
    }
}

