/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.List;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public interface ModifierBuilder {
    public ModifierBuilder add(ModifierEntry var1);

    default public ModifierBuilder add(ModifierId modifier, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("Level must be above 0");
        }
        if (!modifier.equals((Object)ModifierManager.EMPTY)) {
            this.add(new ModifierEntry(modifier, level));
        }
        return this;
    }

    default public ModifierBuilder add(Modifier modifier, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("Level must be above 0");
        }
        if (modifier != ModifierManager.INSTANCE.getDefaultValue()) {
            this.add(new ModifierEntry(modifier, level));
        }
        return this;
    }

    default public ModifierBuilder add(List<ModifierEntry> entries) {
        for (ModifierEntry entry : entries) {
            this.add(entry);
        }
        return this;
    }

    default public ModifierBuilder add(ModifierNBT nbt) {
        this.add(nbt.getModifiers());
        return this;
    }

    public ModifierNBT build();
}

