/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.general;

import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.general.FluidEffectListBuilder;

public record AlternativesFluidEffect<C extends FluidEffectContext>(List<FluidEffect<? super C>> effects, RecordLoadable<AlternativesFluidEffect<C>> getLoader) implements FluidEffect<C>
{
    public static final RecordLoadable<AlternativesFluidEffect<FluidEffectContext.Block>> BLOCK_LOADER = AlternativesFluidEffect.createLoader(FluidEffectListBuilder.BLOCK_EFFECT_LIST);
    public static final RecordLoadable<AlternativesFluidEffect<FluidEffectContext.Entity>> ENTITY_LOADER = AlternativesFluidEffect.createLoader(FluidEffectListBuilder.ENTITY_EFFECT_LIST);

    @Override
    public float apply(FluidStack fluid, EffectLevel level, C context, IFluidHandler.FluidAction action) {
        for (FluidEffect<? super C> fluidEffect : this.effects) {
            float applied = fluidEffect.apply(fluid, level, (FluidEffectContext)context, action);
            if (!(applied > 0.0f)) continue;
            return applied;
        }
        return 0.0f;
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        return this.effects.get(0).getDescription(registryAccess);
    }

    public static FluidEffectListBuilder<FluidEffectContext.Block, AlternativesFluidEffect<FluidEffectContext.Block>> blocks() {
        return FluidEffectListBuilder.builder(list -> new AlternativesFluidEffect<FluidEffectContext.Block>((List<FluidEffect<FluidEffectContext.Block>>)list, BLOCK_LOADER));
    }

    public static FluidEffectListBuilder<FluidEffectContext.Entity, AlternativesFluidEffect<FluidEffectContext.Entity>> entities() {
        return FluidEffectListBuilder.builder(list -> new AlternativesFluidEffect<FluidEffectContext.Entity>((List<FluidEffect<FluidEffectContext.Entity>>)list, ENTITY_LOADER));
    }

    public static <C extends FluidEffectContext> RecordLoadable<AlternativesFluidEffect<C>> createLoader(Loadable<List<FluidEffect<? super C>>> effectList) {
        return RecordLoadable.withLoader((RecordField)effectList.requiredField("effects", AlternativesFluidEffect::effects), AlternativesFluidEffect::new);
    }
}

