/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.block;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PunjiBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    private static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    private static final BooleanProperty NORTHEAST = BooleanProperty.m_61465_((String)"northeast");
    private static final BooleanProperty NORTHWEST = BooleanProperty.m_61465_((String)"northwest");
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final Map<Direction, VoxelShape> BOUNDS = new EnumMap<Direction, VoxelShape>(Direction.class);

    public PunjiBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTHEAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTHWEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.DAMAGE_OTHER;
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        Direction direction;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (facing == (direction = (Direction)state.m_61143_((Property)FACING)) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        Direction north = PunjiBlock.getLocalNorth(direction);
        Direction east = PunjiBlock.getLocalEast(direction);
        if (facing == north) {
            state = (BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.isConnected((LevelReader)world, direction, facingPos)));
        } else if (facing == east) {
            state = (BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.isConnected((LevelReader)world, direction, facingPos)));
        }
        BlockPos northPos = pos.m_121945_(north);
        return (BlockState)((BlockState)state.m_61124_((Property)NORTHEAST, (Comparable)Boolean.valueOf(this.isConnected((LevelReader)world, direction, northPos.m_121945_(east))))).m_61124_((Property)NORTHWEST, (Comparable)Boolean.valueOf(this.isConnected((LevelReader)world, direction, northPos.m_121945_(east.m_122424_()))));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, NORTH, EAST, NORTHEAST, NORTHWEST, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_().m_122424_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        if (!state.m_60710_((LevelReader)world, pos)) {
            boolean isValid = false;
            for (Direction side : Direction.values()) {
                if (side == direction || !(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)side)).m_60710_((LevelReader)world, pos)) continue;
                isValid = true;
                direction = side;
                break;
            }
            if (!isValid) {
                return null;
            }
        }
        Direction north = PunjiBlock.getLocalNorth(direction);
        Direction east = PunjiBlock.getLocalEast(direction);
        BlockPos northPos = pos.m_121945_(north);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.isConnected((LevelReader)world, direction, northPos)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.isConnected((LevelReader)world, direction, pos.m_121945_(east))))).m_61124_((Property)NORTHEAST, (Comparable)Boolean.valueOf(this.isConnected((LevelReader)world, direction, northPos.m_121945_(east))))).m_61124_((Property)NORTHWEST, (Comparable)Boolean.valueOf(this.isConnected((LevelReader)world, direction, northPos.m_121945_(east.m_122424_()))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    private boolean isConnected(LevelReader world, Direction facing, BlockPos target) {
        BlockState state = world.m_8055_(target);
        return state.m_60734_() == this && state.m_61143_((Property)FACING) == facing;
    }

    private static Direction getLocalNorth(Direction facing) {
        return switch (facing) {
            case Direction.DOWN -> Direction.NORTH;
            case Direction.UP -> Direction.SOUTH;
            default -> Direction.UP;
        };
    }

    private static Direction getLocalEast(Direction facing) {
        if (facing.m_122434_() == Direction.Axis.Y) {
            return Direction.EAST;
        }
        return facing.m_122427_();
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos target = pos.m_121945_(direction);
        return world.m_8055_(target).m_60783_((BlockGetter)world, target, direction.m_122424_());
    }

    @Deprecated
    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            Direction side = (Direction)state.m_61143_((Property)FACING);
            Direction.Axis axis = side.m_122434_();
            if (side.m_122421_() == Direction.AxisDirection.POSITIVE ? entityIn.m_20191_().m_82374_(axis) <= (double)((float)pos.m_123304_(axis) + 0.5f) : entityIn.m_20191_().m_82340_(axis) >= (double)((float)pos.m_123304_(axis) + 0.5f)) {
                return;
            }
            float damage = 1.0f;
            if (entityIn.f_19789_ > 0.0f) {
                damage += entityIn.f_19789_ + 1.0f;
            }
            entityIn.m_6469_(entityIn.m_269291_().m_269325_(), damage);
        }
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BOUNDS.get(state.m_61143_((Property)FACING));
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    static {
        BOUNDS.put(Direction.DOWN, Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.375, (double)0.8125));
        BOUNDS.put(Direction.UP, Shapes.m_83048_((double)0.1875, (double)0.625, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125));
        BOUNDS.put(Direction.NORTH, Shapes.m_83048_((double)0.1875, (double)0.1875, (double)0.0, (double)0.8125, (double)0.8125, (double)0.375));
        BOUNDS.put(Direction.SOUTH, Shapes.m_83048_((double)0.1875, (double)0.1875, (double)0.625, (double)0.8125, (double)0.8125, (double)1.0));
        BOUNDS.put(Direction.EAST, Shapes.m_83048_((double)0.625, (double)0.1875, (double)0.1875, (double)1.0, (double)0.8125, (double)0.8125));
        BOUNDS.put(Direction.WEST, Shapes.m_83048_((double)0.0, (double)0.1875, (double)0.1875, (double)0.375, (double)0.8125, (double)0.8125));
    }
}

