/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.modifier.editor;

import com.builtbroken.ai.improvements.modifier.editor.IEntityAiModifier;
import com.builtbroken.ai.improvements.modifier.editor.ModifierNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;

public class ModifierLayer {
    private ModifierNode[] nodes = new ModifierNode[5];
    private int size = 0;
    private boolean resortNormalize = false;
    public final boolean combatAI;

    public ModifierLayer(boolean combatAI) {
        this.combatAI = combatAI;
    }

    public void add(IEntityAiModifier modifier) {
        if (modifier != null) {
            if (this.size == this.nodes.length) {
                this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + 5);
            }
            this.nodes[this.size++] = new ModifierNode(modifier);
        }
    }

    public void handle(Mob entity) {
        GoalSelector goalSelector = this.combatAI ? entity.f_21346_ : entity.f_21345_;
        HashSet<Goal> goalsToRemove = new HashSet<Goal>();
        for (WrappedGoal prioritizedGoal : goalSelector.f_25345_) {
            Goal reGoal = this.process(entity, prioritizedGoal.m_26015_());
            if (reGoal != null) continue;
            goalsToRemove.add(prioritizedGoal.m_26015_());
        }
        for (Goal goal : goalsToRemove) {
            goalSelector.m_25363_(goal);
        }
        if (this.resortNormalize) {
            this.resortNormalize = false;
            this.resort(true);
        }
    }

    protected Goal process(Mob entity, Goal goal) {
        for (int i = 0; i < this.nodes.length; ++i) {
            ModifierNode modifier = this.nodes[i];
            if (modifier == null) continue;
            Goal reGoal = modifier.handle(entity, goal);
            if (reGoal != goal && i != 0 && modifier.callCount > this.nodes[i - 1].callCount) {
                this.bubble(modifier, i);
            }
            if (reGoal == goal) continue;
            return reGoal;
        }
        return goal;
    }

    protected void resort(boolean normalize) {
        Arrays.sort(this.nodes, Comparator.comparingInt(m -> m.callCount));
        if (normalize) {
            int sum = Arrays.stream(this.nodes).mapToInt(m -> m.callCount).sum();
            Arrays.stream(this.nodes).forEach(m -> {
                m.callCount = (int)Math.floor((double)m.callCount / (double)sum);
            });
        }
    }

    protected void bubble(ModifierNode modifier, int i) {
        ++modifier.callCount;
        if (modifier.callCount >= 0x3FFFFFFF) {
            this.resortNormalize = true;
        } else {
            ModifierNode m = this.nodes[i];
            this.nodes[i] = this.nodes[i - 1];
            this.nodes[i - 1] = m;
        }
    }
}

