/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class JellyfishModel<T extends Entity>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart tentaclesMain;
    private final ModelPart tentaclesLeft;
    private final ModelPart tentaclesRight;
    private final ModelPart frill;
    private final ModelPart heart;

    public JellyfishModel(ModelPart part) {
        this.head = part.m_171324_("head");
        this.tentaclesMain = part.m_171324_("tentacles_main");
        this.tentaclesLeft = part.m_171324_("tentacles_left");
        this.tentaclesRight = part.m_171324_("tentacles_right");
        this.frill = part.m_171324_("frill");
        this.heart = part.m_171324_("heart");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelDefinition = new MeshDefinition();
        PartDefinition def = modelDefinition.m_171576_();
        def.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171481_(-2.5f, -2.5f, -5.0f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-3.0f));
        def.m_171599_("tentacles_main", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-3.5f));
        def.m_171599_("tentacles_left", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(2.0f, -3.0f, 0.0f, 0.0f, 6.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-3.5f));
        def.m_171599_("tentacles_right", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-2.0f, -3.0f, 0.0f, 0.0f, 6.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-3.5f));
        def.m_171599_("frill", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -3.0f, 0.0f, 6.0f, 6.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-5.0f));
        def.m_171599_("heart", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171481_(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelDefinition, (int)64, (int)32);
    }

    @Nonnull
    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.head, (Object)this.tentaclesMain, (Object)this.tentaclesLeft, (Object)this.tentaclesRight, (Object)this.heart, (Object)this.frill);
    }

    public void m_7695_(@Nonnull PoseStack matrixStack, @Nonnull VertexConsumer builder, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
    }

    public void m_6973_(@Nonnull T jellyfish, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float stillMovement = 0.1f;
        if (!jellyfish.m_20069_()) {
            stillMovement = 0.05f;
        }
        this.tentaclesLeft.f_104204_ = -stillMovement * 0.25f * Mth.m_14031_((float)(0.3f * ageInTicks)) + Mth.m_14089_((float)(limbSwing * 0.4662f)) * 0.5f * limbSwingAmount;
        this.tentaclesMain.f_104204_ = -stillMovement * 0.25f * Mth.m_14031_((float)(0.3f * ageInTicks)) + Mth.m_14089_((float)(limbSwing * 0.4662f)) * 0.5f * limbSwingAmount;
        this.tentaclesRight.f_104204_ = -stillMovement * 0.25f * Mth.m_14031_((float)(0.3f * ageInTicks)) + Mth.m_14089_((float)(limbSwing * 0.4662f)) * 0.5f * limbSwingAmount;
    }
}

