/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.network.message;

import com.mrbysco.structurecompass.client.ClientHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class OpenCompassMessage {
    public InteractionHand hand;
    public ItemStack compass;
    public List<ResourceLocation> structureList;

    public OpenCompassMessage(InteractionHand hand, ItemStack compassStack, List<ResourceLocation> structureList) {
        this.hand = hand;
        this.compass = compassStack;
        this.structureList = structureList;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        buf.writeItemStack(this.compass, false);
        buf.writeInt(this.structureList.size());
        for (ResourceLocation location : this.structureList) {
            buf.m_130085_(location);
        }
    }

    public static OpenCompassMessage decode(FriendlyByteBuf packetBuffer) {
        InteractionHand hand = packetBuffer.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack stack = packetBuffer.m_130267_();
        ArrayList<ResourceLocation> allStructures = new ArrayList<ResourceLocation>();
        int size = packetBuffer.readInt();
        for (int i = 0; i < size; ++i) {
            allStructures.add(packetBuffer.m_130281_());
        }
        return new OpenCompassMessage(hand, stack, allStructures);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                Compass.openScreen(this.hand, this.compass, this.structureList).run();
            }
        });
        ctx.setPacketHandled(true);
    }

    private static class Compass {
        private Compass() {
        }

        private static DistExecutor.SafeRunnable openScreen(final InteractionHand hand, final ItemStack compassStack, final List<ResourceLocation> structureList) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    ClientHandler.openStructureScreen(hand, compassStack, structureList);
                }
            };
        }
    }
}

