/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.helper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.impl.BloodMagicAPI;

public class InventoryHelper {
    private static Map<String, Function<Player, NonNullList<ItemStack>>> inventoryProvider = BloodMagicAPI.INSTANCE.getInventoryProvider();

    public static NonNullList<ItemStack> getInventory(Player player, String inventoryKey) {
        NonNullList inventory = NonNullList.m_122779_();
        inventory.addAll((Collection)inventoryProvider.get(inventoryKey).apply(player));
        return inventory;
    }

    public static NonNullList<ItemStack> getAllInventories(Player player) {
        NonNullList inventory = NonNullList.m_122779_();
        inventoryProvider.forEach((identifier, provider) -> inventory.addAll((Collection)provider.apply(player)));
        return inventory;
    }

    public static NonNullList<ItemStack> getAllInventoriesExcluding(Player player, List<String> excludedInventoryKeys) {
        NonNullList inventory = NonNullList.m_122779_();
        inventoryProvider.forEach((identifier, provider) -> {
            if (!identifier.equals(excludedInventoryKeys)) {
                inventory.addAll((Collection)provider.apply(player));
            }
        });
        return inventory;
    }

    public static NonNullList<ItemStack> getActiveInventories(Player player) {
        Map<String, Function<Player, NonNullList<ItemStack>>> activeInventoryProvider = BloodMagicAPI.INSTANCE.getActiveInventoryProvider();
        NonNullList inventories = NonNullList.m_122779_();
        activeInventoryProvider.forEach((identifier, provider) -> inventories.addAll((Collection)provider.apply(player)));
        inventories.add((Object)player.m_21120_(InteractionHand.MAIN_HAND));
        inventories.add((Object)player.m_21120_(InteractionHand.OFF_HAND));
        return inventories;
    }
}

