/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.network.SetClientVelocityPacket;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="jumping")
public class RitualJumping
extends Ritual {
    public static final String JUMP_RANGE = "jumpRange";
    public static final String JUMP_POWER = "jumpPower";

    public RitualJumping() {
        super("ritualJump", 0, 5000, "ritual.bloodmagic.jumpRitual");
        this.addBlockRange(JUMP_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 1, -1), 3, 1, 3));
        this.setMaximumVolumeAndDistanceOfRange(JUMP_RANGE, 0, 5, 5);
        this.addBlockRange(JUMP_POWER, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1, 5, 1));
        this.setMaximumVolumeAndDistanceOfRange(JUMP_POWER, 0, 1, 100);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        AreaDescriptor jumpRange = masterRitualStone.getBlockRange(JUMP_RANGE);
        List entities = world.m_45976_(LivingEntity.class, jumpRange.getAABB(masterRitualStone.getMasterBlockPos()));
        for (LivingEntity entity : entities) {
            if (totalEffects >= maxEffects) break;
            double motionY = (double)masterRitualStone.getBlockRange(JUMP_POWER).getHeight() * 0.3;
            entity.f_19789_ = 0.0f;
            if (entity.m_6144_()) continue;
            Vec3 motion = entity.m_20184_();
            double motionX = motion.m_7096_();
            double motionZ = motion.m_7094_();
            ++totalEffects;
            entity.m_20334_(motionX, motionY, motionZ);
            if (!(entity instanceof ServerPlayer)) continue;
            BloodMagic.packetHandler.sendTo(new SetClientVelocityPacket(motionX, motionY, motionZ), (ServerPlayer)entity);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return this.getBlockRange(JUMP_POWER).getHeight();
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        for (int i = -1; i <= 1; ++i) {
            this.addCornerRunes(components, 1, i, EnumRuneType.AIR);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualJumping();
    }
}

